/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.storage;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.exceptions.AppEngException;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.Platform;
import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.common.item.ItemBackpackTerminal;
import com.asdflj.ae2thing.common.item.ItemInfinityCell;
import com.asdflj.ae2thing.common.storage.CellInventoryHandler;
import com.asdflj.ae2thing.common.storage.IModInv;
import com.asdflj.ae2thing.common.storage.IStorageItemCell;
import com.asdflj.ae2thing.common.storage.ITCellInventory;
import com.asdflj.ae2thing.common.storage.backpack.AdventureBackpackHandler;
import com.asdflj.ae2thing.common.storage.backpack.BackPackHandler;
import com.asdflj.ae2thing.common.storage.backpack.FTRBackpackHandler;
import com.asdflj.ae2thing.common.storage.infinityCell.InfinityItemCellInventory;
import com.asdflj.ae2thing.util.ModAndClassUtil;
import com.darkona.adventurebackpack.item.ItemAdventureBackpack;
import de.eydamos.backpack.item.ItemBackpackBase;
import de.eydamos.backpack.util.BackpackUtil;
import forestry.storage.items.ItemBackpack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CellInventory
implements ITCellInventory {
    protected final ItemStack cellItem;
    protected IStorageItemCell cellType;
    protected final ISaveProvider container;
    protected final EntityPlayer player;
    protected final List<IInventory> modInv = new ArrayList<IInventory>();
    protected IItemList<IAEItemStack> cellItems = AEApi.instance().storage().createItemList();

    public CellInventory(ItemStack o, ISaveProvider c, EntityPlayer p) throws AppEngException {
        if (o == null) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        this.cellItem = o;
        this.container = c;
        this.player = p;
        this.cellType = (IStorageItemCell)this.cellItem.func_77973_b();
        this.getAllInv();
        this.loadCellItems();
    }

    private void getAllInv() {
        if (ModAndClassUtil.FTR) {
            this.modInv.addAll(this.getModInv(player -> Arrays.stream(player.field_71071_by.field_70462_a).filter(x -> x != null && x.func_77973_b() instanceof ItemBackpack).map(x -> new FTRBackpackHandler(player, (ItemStack)x)).collect(Collectors.toList())));
        }
        if (ModAndClassUtil.ADVENTURE_BACKPACK) {
            this.modInv.addAll(this.getModInv(player -> Arrays.stream(player.field_71071_by.field_70462_a).filter(x -> x != null && x.func_77973_b() instanceof ItemAdventureBackpack).map(AdventureBackpackHandler::new).collect(Collectors.toList())));
        }
        if (ModAndClassUtil.BACKPACK) {
            this.modInv.addAll(this.getModInv(player -> Arrays.stream(player.field_71071_by.field_70462_a).filter(x -> x != null && x.func_77973_b() instanceof ItemBackpackBase && !BackpackUtil.isEnderBackpack((ItemStack)x)).map(x -> new BackPackHandler(player, (ItemStack)x)).collect(Collectors.toList())));
        }
        this.modInv.addAll(this.getModInv(player -> Arrays.stream(player.field_71071_by.field_70462_a).filter(x -> AE2ThingAPI.instance().isBackpackItemInv((ItemStack)x)).map(x -> AE2ThingAPI.instance().getBackpackInv((ItemStack)x)).filter(Objects::nonNull).collect(Collectors.toList())));
    }

    private List<IInventory> getModInv(IModInv inv) {
        return inv.getInv(this.player);
    }

    public static IMEInventoryHandler<IAEItemStack> getCell(ItemStack o, ISaveProvider container, EntityPlayer player) {
        try {
            if (o.func_77973_b() instanceof ItemBackpackTerminal) {
                return new CellInventoryHandler(new CellInventory(o, container, player));
            }
            if (o.func_77973_b() instanceof ItemInfinityCell) {
                return new CellInventoryHandler(new InfinityItemCellInventory(o, container, player));
            }
        }
        catch (AppEngException appEngException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public ItemStack getItemStack() {
        return this.cellItem;
    }

    @Override
    public FuzzyMode getFuzzyMode() {
        return null;
    }

    @Override
    public IInventory getConfigInventory() {
        return null;
    }

    @Override
    public IInventory getUpgradesInventory() {
        return null;
    }

    @Override
    public int getBytesPerType() {
        return 0;
    }

    @Override
    public boolean canHoldNewItem(ItemStack is) {
        block0: for (IInventory inv : this.modInv) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_94041_b(i, is)) {
                    return true;
                }
                if (inv.func_70301_a(i) == null) continue block0;
            }
        }
        return false;
    }

    @Override
    public long getTotalBytes() {
        return 0L;
    }

    @Override
    public long getFreeBytes() {
        return 0L;
    }

    @Override
    public long getUsedBytes() {
        return 0L;
    }

    @Override
    public long getTotalItemTypes() {
        return 0L;
    }

    @Override
    public long getStoredItemCount() {
        return 0L;
    }

    @Override
    public long getStoredItemTypes() {
        return 0L;
    }

    @Override
    public long getRemainingItemTypes() {
        return 0L;
    }

    @Override
    public long getRemainingItemCount() {
        return 0L;
    }

    @Override
    public int getUnusedItemCount() {
        return 0;
    }

    @Override
    public int getStatusForCell() {
        return 0;
    }

    @Override
    public String getOreFilter() {
        return null;
    }

    private ItemStack injectItem(ItemStack is) {
        ItemStack injectItem = is.func_77946_l();
        block0: for (IInventory inv : this.modInv) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_94041_b(i, injectItem)) {
                    ItemStack added = injectItem.func_77946_l();
                    if (inv.func_70301_a(i) == null) {
                        added.field_77994_a = Math.min(added.func_77976_d(), injectItem.field_77994_a);
                        inv.func_70299_a(i, added);
                    } else {
                        ItemStack slotItem = inv.func_70301_a(i).func_77946_l();
                        added.field_77994_a = Math.min(added.func_77976_d() - slotItem.field_77994_a, injectItem.field_77994_a);
                        slotItem.field_77994_a += added.field_77994_a;
                        inv.func_70299_a(i, slotItem);
                    }
                    injectItem.field_77994_a -= added.field_77994_a;
                    if (injectItem.field_77994_a > 0) continue;
                    return injectItem;
                }
                if (inv.func_70301_a(i) == null) continue block0;
            }
        }
        return injectItem;
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, BaseActionSource src) {
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        if (this.cellType.isBlackListed(this.cellItem, input)) {
            return input;
        }
        if (mode == Actionable.MODULATE) {
            ItemStack is = this.injectItem(input.getItemStack());
            if (is.field_77994_a == 0) {
                this.cellItems.add((IAEStack)input);
                return null;
            }
            IAEItemStack l = input.copy();
            IAEItemStack noAdded = AEApi.instance().storage().createItemStack(is);
            l.decStackSize(noAdded.getStackSize());
            this.cellItems.add((IAEStack)l);
            return noAdded;
        }
        return null;
    }

    protected IItemList<IAEItemStack> getCellItems() {
        if (this.cellItems == null) {
            this.loadCellItems();
        }
        return this.cellItems;
    }

    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        if (request == null) {
            return null;
        }
        long size = request.getStackSize();
        IAEItemStack results = null;
        IAEItemStack l = (IAEItemStack)this.getCellItems().findPrecise((IAEStack)request);
        if (l != null) {
            results = l.copy();
            if (l.getStackSize() <= size) {
                results.setStackSize(l.getStackSize());
                if (mode == Actionable.MODULATE) {
                    this.extractItems(request.getItemStack());
                    l.setStackSize(0L);
                }
            } else {
                results.setStackSize(size);
                if (mode == Actionable.MODULATE) {
                    this.extractItems(request.getItemStack());
                    l.setStackSize(l.getStackSize() - size);
                }
            }
        }
        return results;
    }

    private void extractItems(ItemStack extractItem) {
        ItemStack extItem = extractItem.func_77946_l();
        for (IInventory inv : this.modInv) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack is = inv.func_70301_a(i);
                if (!Platform.isSameItemPrecise((ItemStack)is, (ItemStack)extItem)) continue;
                int size = is.field_77994_a;
                if (size > extItem.field_77994_a) {
                    inv.func_70298_a(i, extItem.field_77994_a);
                    return;
                }
                inv.func_70299_a(i, null);
                extItem.field_77994_a -= size;
                if (extItem.field_77994_a > 0) continue;
                return;
            }
        }
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        for (IAEItemStack i : this.getCellItems()) {
            out.add((IAEStack)i);
        }
        return out;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    @Override
    public double getIdleDrain(ItemStack is) {
        return 0.0;
    }

    @Override
    public void loadCellItems() {
        this.cellItems.resetStatus();
        for (IInventory inv : this.modInv) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack is = inv.func_70301_a(i);
                if (is == null) continue;
                this.cellItems.add((IAEStack)AEApi.instance().storage().createItemStack(is));
            }
        }
    }
}

