/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.item;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.core.localization.GuiText;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.util.Platform;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.common.item.BaseItem;
import com.asdflj.ae2thing.common.item.IInfinityStorageCell;
import com.asdflj.ae2thing.common.storage.ITFluidCellInventory;
import com.asdflj.ae2thing.common.storage.ITFluidCellInventoryHandler;
import com.asdflj.ae2thing.common.tabs.AE2ThingTabs;
import com.asdflj.ae2thing.loader.IRegister;
import com.glodblock.github.api.FluidCraftAPI;
import com.glodblock.github.common.storage.IStorageFluidCell;
import cpw.mods.fml.common.registry.GameRegistry;
import java.text.NumberFormat;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class ItemInfinityFluidCell
extends BaseItem
implements IStorageFluidCell,
IRegister<ItemInfinityFluidCell>,
IInfinityStorageCell {
    private final int perType = 1;
    private final double idleDrain = 2000.0;

    public ItemInfinityFluidCell() {
        this.func_77625_d(1);
        this.func_77655_b("infinity_fluid_cell");
        this.func_111206_d(AE2Thing.resource("infinity_fluid_cell").toString());
    }

    @Override
    public ItemInfinityFluidCell register() {
        GameRegistry.registerItem((Item)this, (String)"infinity_fluid_cell", (String)"ae2thing");
        this.func_77637_a(AE2ThingTabs.INSTANCE);
        return this;
    }

    public long getBytes(ItemStack cellItem) {
        return Long.MAX_VALUE;
    }

    public int getBytesPerType(ItemStack cellItem) {
        return this.perType;
    }

    public boolean isBlackListed(ItemStack cellItem, IAEFluidStack requestedAddition) {
        return requestedAddition == null || requestedAddition.getFluid() == null || FluidCraftAPI.instance().isBlacklistedInStorage(requestedAddition.getFluid().getClass());
    }

    public boolean storableInStorageCell() {
        return false;
    }

    public boolean isStorageCell(ItemStack i) {
        return false;
    }

    public double getIdleDrain(ItemStack is) {
        return this.idleDrain;
    }

    public int getTotalTypes(ItemStack cellItem) {
        return Integer.MAX_VALUE;
    }

    public boolean isEditable(ItemStack is) {
        return true;
    }

    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 0);
    }

    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData((ItemStack)is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf((String)fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData((ItemStack)is).func_74778_a("FuzzyMode", fzMode.name());
    }

    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        ITFluidCellInventoryHandler handler;
        ITFluidCellInventory cellInventory;
        IMEInventoryHandler inventory = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.FLUIDS);
        if (inventory instanceof ITFluidCellInventoryHandler && (cellInventory = (handler = (ITFluidCellInventoryHandler)inventory).getCellInv()) != null) {
            lines.add(EnumChatFormatting.WHITE + NumberFormat.getInstance().format(cellInventory.getStoredFluidTypes()) + EnumChatFormatting.GRAY + " " + GuiText.Of.getLocal() + " " + EnumChatFormatting.DARK_GREEN + cellInventory.getTotalFluidTypes() + " " + EnumChatFormatting.GRAY + GuiText.Types.getLocal());
            String uid = cellInventory.getUUID();
            if (!uid.isEmpty()) {
                lines.add(uid);
            }
            if (handler.isPreformatted()) {
                String list = (handler.getIncludeExcludeMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).getLocal();
                lines.add(GuiText.Partitioned.getLocal() + " - " + list + ' ' + GuiText.Precise.getLocal());
                if (GuiScreen.func_146272_n()) {
                    lines.add(GuiText.Filter.getLocal() + ": ");
                    for (IAEFluidStack aeFluidStack : handler.getPartitionInv()) {
                        if (aeFluidStack == null) continue;
                        lines.add("  " + aeFluidStack.getFluidStack().getLocalizedName());
                    }
                } else {
                    lines.add(StatCollector.func_74838_a((String)"ae2fc.tooltip.shift_for_more"));
                }
            }
        }
    }
}

