/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui.container;

import appeng.api.AEApi;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerNull;
import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotCraftingTerm;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.IContainerCraftingPacket;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.inventory.item.PortableItemInventory;
import com.asdflj.ae2thing.network.SPacketMEItemInvUpdate;
import com.asdflj.ae2thing.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;

public class ContainerCraftingTerminal
extends AEBaseContainer
implements IConfigurableObject,
IConfigManagerHost,
IMEMonitorHandlerReceiver<IAEItemStack>,
IAEAppEngInventory,
IContainerCraftingPacket {
    protected final PortableItemInventory it;
    protected IConfigManagerHost gui;
    protected IConfigManager serverCM;
    protected final IConfigManager clientCM;
    protected ITerminalHost host;
    protected IMEMonitor<IAEItemStack> monitor;
    private final IItemList<IAEItemStack> items = AEApi.instance().storage().createItemList();
    private final SlotCraftingMatrix[] craftingSlots = new SlotCraftingMatrix[9];
    private final SlotCraftingTerm outputSlot;

    public ContainerCraftingTerminal(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, (Object)monitorable);
        this.host = monitorable;
        this.clientCM = new ConfigManager((IConfigManagerHost)this);
        this.clientCM.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.clientCM.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        this.clientCM.registerSetting(Settings.TYPE_FILTER, (Enum)TypeFilter.ALL);
        if (Platform.isServer()) {
            this.serverCM = monitorable.getConfigManager();
            this.monitor = monitorable.getItemInventory();
            this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
            this.setCellInventory((IMEInventoryHandler)this.monitor);
            this.setPowerSource((IEnergySource)monitorable);
        } else {
            this.monitor = null;
        }
        this.it = (PortableItemInventory)monitorable;
        this.lockSlot();
        IInventory crafting = this.it.getInventoryByName("crafting");
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                SlotCraftingMatrix slotCraftingMatrix = new SlotCraftingMatrix((Container)this, crafting, x + y * 3, 37 + x * 18, -72 + y * 18);
                this.craftingSlots[x + y * 3] = slotCraftingMatrix;
                this.func_75146_a((Slot)slotCraftingMatrix);
            }
        }
        AppEngInternalInventory output = new AppEngInternalInventory((IAEAppEngInventory)this, 1);
        this.outputSlot = new SlotCraftingTerm(this.getPlayerInv().field_70458_d, this.getActionSource(), this.getPowerSource(), (IStorageMonitorable)monitorable, crafting, crafting, (IInventory)output, 131, -54, (IContainerCraftingPacket)this);
        this.func_75146_a((Slot)this.outputSlot);
        this.bindPlayerInventory(ip, 0, 0);
        this.func_75130_a(crafting);
    }

    public void func_82847_b(ICrafting c) {
        super.func_82847_b(c);
        if (this.field_75149_d.isEmpty() && this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    private void lockSlot() {
        this.lockPlayerInventorySlot(this.it.getInventorySlot());
        for (int s : Util.getBackpackSlot(this.getInventoryPlayer().field_70458_d)) {
            this.lockPlayerInventorySlot(s);
        }
    }

    public void func_75130_a(IInventory par1IInventory) {
        ContainerNull cn = new ContainerNull();
        InventoryCrafting ic = new InventoryCrafting((Container)cn, 3, 3);
        for (int x = 0; x < 9; ++x) {
            ic.func_70299_a(x, this.craftingSlots[x].func_75211_c());
        }
        this.outputSlot.func_75215_d(CraftingManager.func_77594_a().func_82787_a(ic, this.getPlayerInv().field_70458_d.field_70170_p));
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    public IMEMonitor<IAEItemStack> getMonitor() {
        return this.monitor;
    }

    protected boolean isInvalid() {
        return this.monitor == null;
    }

    public void func_75142_b() {
        if (Platform.isServer()) {
            if (this.isInvalid()) {
                this.setValidContainer(false);
            }
            if (this.serverCM != null) {
                for (Settings set : this.serverCM.getSettings()) {
                    Enum sideRemote;
                    Enum sideLocal = this.serverCM.getSetting(set);
                    if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                    this.clientCM.putSetting(set, sideLocal);
                    for (Object crafter : this.field_75149_d) {
                        try {
                            NetworkHandler.instance.sendTo((AppEngPacket)new PacketValueConfig(set.name(), sideLocal.name()), (EntityPlayerMP)crafter);
                        }
                        catch (IOException e) {
                            AELog.debug((Throwable)e);
                        }
                    }
                }
            }
            this.processItemList();
            super.func_75142_b();
        }
    }

    public void func_75132_a(ICrafting c) {
        super.func_75132_a(c);
        this.queueInventory(c);
    }

    protected void processItemList() {
        if (!this.items.isEmpty()) {
            IItemList monitorCache = this.monitor.getStorageList();
            ArrayList<IAEItemStack> toSend = new ArrayList<IAEItemStack>();
            for (IAEItemStack is : this.items) {
                IAEItemStack send = (IAEItemStack)monitorCache.findPrecise((IAEStack)is);
                if (send != null) {
                    toSend.add(send);
                    continue;
                }
                is.setStackSize(0L);
                toSend.add(is);
            }
            SPacketMEItemInvUpdate piu = new SPacketMEItemInvUpdate();
            piu.addAll(toSend);
            for (Object c : this.field_75149_d) {
                if (!(c instanceof EntityPlayer)) continue;
                AE2Thing.proxy.netHandler.sendTo(piu, (EntityPlayerMP)c);
            }
            this.items.resetStatus();
        }
    }

    public IConfigManager getConfigManager() {
        if (Platform.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public boolean isValid(Object verificationToken) {
        return this.monitor != null;
    }

    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, BaseActionSource actionSource) {
        for (IAEItemStack is : change) {
            this.items.add((IAEStack)is);
        }
    }

    protected void queueInventory(ICrafting c) {
        if (Platform.isServer() && c instanceof EntityPlayer && this.monitor != null) {
            IItemList monitorCache = this.monitor.getStorageList();
            ArrayList<IAEItemStack> toSend = new ArrayList<IAEItemStack>();
            for (IAEItemStack is : monitorCache) {
                toSend.add(is);
            }
            SPacketMEItemInvUpdate piu = new SPacketMEItemInvUpdate();
            piu.addAll(toSend);
            AE2Thing.proxy.netHandler.sendTo(piu, (EntityPlayerMP)c);
        }
    }

    public void onListUpdate() {
        for (Object c : this.field_75149_d) {
            if (!(c instanceof ICrafting)) continue;
            ICrafting cr = (ICrafting)c;
            this.queueInventory(cr);
        }
    }

    protected IConfigManagerHost getGui() {
        return this.gui;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    public IGridNode getNetworkNode() {
        return null;
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("player")) {
            return this.getInventoryPlayer();
        }
        return this.it.getInventoryByName(name);
    }

    public boolean useRealItems() {
        return true;
    }

    public ItemStack[] getViewCells() {
        return new ItemStack[0];
    }

    public void saveChanges() {
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }
}

