/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.api;

import appeng.api.storage.data.IAEItemStack;
import com.asdflj.ae2thing.api.IAE2ThingAPI;
import com.asdflj.ae2thing.api.IBackpackItem;
import com.asdflj.ae2thing.common.storage.StorageManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class AE2ThingAPI
implements IAE2ThingAPI {
    private static final AE2ThingAPI API = new AE2ThingAPI();
    private final Set<Class<? extends Item>> backpackItems = new HashSet<Class<? extends Item>>();
    private StorageManager storageManager = null;
    private final List<IAEItemStack> pinItems = new ArrayList<IAEItemStack>();
    public static int maxPinSize = 9;

    public static AE2ThingAPI instance() {
        return API;
    }

    @Override
    public boolean isBlacklistedInStorage(Item item) {
        if (item instanceof IBackpackItem) {
            return true;
        }
        for (Class<? extends Item> cls : this.backpackItems) {
            if (!cls.isInstance(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void blacklistItemInStorage(Class<? extends Item> item) {
        this.backpackItems.add(item);
    }

    @Override
    public void addBackpackItem(Class<? extends Item> item) {
        this.blacklistItemInStorage(item);
    }

    @Override
    public boolean isBackpackItem(Item item) {
        return this.isBlacklistedInStorage(item);
    }

    @Override
    public boolean isBackpackItem(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() != null && this.isBackpackItem(itemStack.func_77973_b());
    }

    @Override
    public IInventory getBackpackInv(ItemStack is) {
        if (is == null || is.func_77973_b() == null) {
            return null;
        }
        Item item = is.func_77973_b();
        if (item instanceof IBackpackItem) {
            IBackpackItem ibi = (IBackpackItem)item;
            return ibi.getInventory(is);
        }
        return null;
    }

    @Override
    public boolean isBackpackItemInv(ItemStack is) {
        if (is == null || is.func_77973_b() == null) {
            return false;
        }
        return is.func_77973_b() instanceof IBackpackItem;
    }

    @Override
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public void setStorageManager(StorageManager manager) {
        this.storageManager = manager;
    }

    @Override
    public List<IAEItemStack> getPinItems() {
        return this.pinItems;
    }

    @Override
    public void setPinItems(List<IAEItemStack> items) {
        this.pinItems.clear();
        this.pinItems.addAll(items);
    }

    @Override
    public void togglePinItems(IAEItemStack stack) {
        if (stack == null || this.pinItems.remove(stack)) {
            return;
        }
        this.pinItems.add(stack);
        if (this.pinItems.size() > maxPinSize) {
            ArrayList<IAEItemStack> tmp = new ArrayList<IAEItemStack>(this.pinItems.subList(this.pinItems.size() - maxPinSize, this.pinItems.size()));
            this.pinItems.clear();
            this.pinItems.addAll(tmp);
        }
    }
}

