/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import makamys.coretweaks.Compat;
import makamys.coretweaks.Config;
import makamys.coretweaks.CoreTweaks;
import makamys.coretweaks.optimization.transformercache.lite.TransformerCache;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfigPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
        Config.reload();
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        MixinEnvironment.Phase phase = MixinEnvironment.getCurrentEnvironment().getPhase();
        if (phase == MixinEnvironment.Phase.PREINIT) {
            if (!MixinConfigPlugin.isForgeSplashEnabled() && Config.forgeFastStepMessageStrip.isActive()) {
                mixins.add("optimization.fmlmessagestrip.MixinFMLClientHandler");
            }
        } else if (phase != MixinEnvironment.Phase.INIT && phase == MixinEnvironment.Phase.DEFAULT) {
            String fcVersion;
            if (Config.transformerCache.isActive() && Config.transformerCacheMode == Config.TransformerCache.LITE && Config.lateLiteTransformerCache) {
                TransformerCache.instance.init(true);
            }
            if (Config.jarDiscovererCache.isActive() && MixinConfigPlugin.disableFoamFixJarDiscovererTransformer()) {
                mixins.add("optimization.jardiscoverercache.MixinJarDiscoverer");
            }
            if (Config.clientChunkMap.isActive()) {
                mixins.add("optimization.clientchunkmap.MixinChunkProviderClient");
            }
            if (Config.crashHandler.isActive()) {
                mixins.add("tweak.crashhandler.MixinMinecraft");
            }
            if (Config.lightFixStare.isActive()) {
                mixins.add("tweak.lightfixstare.MixinWorld");
            }
            if (Config.fixDisplayListDelete.isActive()) {
                mixins.add("bugfix.displaylistdelete.MixinRenderGlobal");
            }
            if (Config.fixHeightmapRange.isActive()) {
                mixins.add("bugfix.heightmaprange.MixinChunk");
            }
            if (Config.fixSmallEntitySwim.isActive()) {
                mixins.add("bugfix.smallentityswim.MixinEntity");
            }
            if (Config.fixForgeChatLinkCrash.isActive()) {
                mixins.add("bugfix.chatlinkcrash.MixinForgeHooks");
            }
            if (Config.clampFarPlaneDistance.isActive()) {
                mixins.add("tweak.farplane.MixinEntityRenderer");
            }
            if (Config.disableFog.isActive()) {
                mixins.add("tweak.disablefog.MixinEntityRenderer");
            }
            if (Config.uncapCreateWorldGuiTextFieldLength.isActive()) {
                mixins.add("tweak.newworldguimaxlength.MixinGuiCreateWorld");
            }
            if (Config.extendSprintTimeLimit.isActive()) {
                mixins.add("tweak.extendsprint.MixinEntityPlayerSP");
            }
            if (Config.fixEntityTracking.isActive()) {
                mixins.add("bugfix.forge5160.MixinChunk");
                mixins.add("bugfix.forge5160.MixinEntity");
                mixins.add("bugfix.forge5160.MixinWorld");
            }
            if (Config.guiClickSound.isActive()) {
                mixins.add("bugfix.guiclicksound.MixinGuiListExtended");
            }
            if (Config.fixIntelRendering.isActive()) {
                mixins.add(!Config.useAlternateIntelRenderingFix ? "bugfix.intelcolor.MixinTessellator" : "bugfix.intelcolor.MixinOpenGlHelper");
            }
            if (Config.forceUncapFramerate.isActive()) {
                mixins.add("tweak.synctweak.MixinMinecraft");
            }
            if (Config.optimizeGetPendingBlockUpdates.isActive()) {
                mixins.add("optimization.getpendingblockupdates.MixinWorldServer");
            }
            if (Config.restoreTravelSound.isActive()) {
                mixins.add("bugfix.restoretravelsound.MixinNetHandlerPlayClient");
            }
            if (Config.tweakCloudHeightCheck.isActive()) {
                mixins.add("tweak.cloudheightcheck.MixinEntityRenderer");
            }
            if (Compat.isOptifinePresent()) {
                if (Config.ofFixUpdateRenderersReturnValue.isActive()) {
                    mixins.add("tweak.ofupdaterenderersreturn.MixinRenderGlobal");
                }
                if (Config.ofOptimizeWorldRenderer.isActive()) {
                    mixins.add("optimization.ofupdaterendererreflect.MixinWorldRenderer");
                }
                if (Config.ofUnlockCustomSkyMinRenderDistance.isActive()) {
                    mixins.add("tweak.ofcustomsky.MixinOFD6CustomSky");
                }
            }
            if (Config.fcOptimizeTextureUpload.isActive() && (fcVersion = (String)Launch.blackboard.get("fcVersion")) != null) {
                boolean ok = true;
                switch (fcVersion) {
                    case "1.23": {
                        mixins.add("optimization.fastcrafttextureload.MixinFastcraft1_23TextureUtil");
                        break;
                    }
                    case "1.25": {
                        mixins.add("optimization.fastcrafttextureload.MixinFastcraft1_25TextureUtil");
                        break;
                    }
                    default: {
                        CoreTweaks.LOGGER.warn("Unsupported FastCraft version: " + fcVersion + ". fcOptimizeTextureUpload won't work.");
                        ok = false;
                    }
                }
                if (ok) {
                    Set transformerExceptions = (Set)ObfuscationReflectionHelper.getPrivateValue(LaunchClassLoader.class, (Object)Launch.classLoader, (String[])new String[]{"transformerExceptions"});
                    transformerExceptions.remove("fastcraft");
                    mixins.add("optimization.fastcrafttextureload.MixinTextureUtil");
                    mixins.add("optimization.fastcrafttextureload.MixinTextureMap");
                }
            }
            if (Config.threadedTextureLoader.isActive()) {
                mixins.add("optimization.threadedtextureloader.ITextureMap");
                mixins.add("optimization.threadedtextureloader.MixinTextureMap");
            }
            if (Config.fastFolderResourcePack.isActive()) {
                mixins.add("optimization.folderresourcepack.MixinFolderResourcePack");
            }
            if (Config.fastDefaultResourcePack.isActive()) {
                mixins.add("optimization.defaultresourcepack.MixinDefaultResourcePack");
            }
            if (Config.tcpNoDelay.isActive()) {
                mixins.add("optimization.tcpnodelay.MixinChannelInitializers");
            }
            if (Config.enhanceMapStorageErrors.isActive()) {
                mixins.add("diagnostics.enhancemapstorageerrors.MixinMapStorage");
            }
            if (Config.detectDataWatcherIdConflicts.isActive()) {
                mixins.add("diagnostics.detectdatawatcherconflict.MixinDataWatcher");
            }
        }
        return mixins;
    }

    private static boolean disableFoamFixJarDiscovererTransformer() {
        try {
            Class<?> bugfixModClassTransformerClass = null;
            try {
                bugfixModClassTransformerClass = Class.forName("pl.asie.foamfix.bugfixmod.coremod.BugfixModClassTransformer");
                CoreTweaks.LOGGER.info("Found BugfixModClassTransformer, applying compatibility hack to forcibly disable FoamFix's jarDiscovererMemoryLeakFix");
                Object instance = bugfixModClassTransformerClass.getField("instance").get(null);
                Map patchers = (Map)ReflectionHelper.getPrivateValue(bugfixModClassTransformerClass, (Object)instance, (String[])new String[]{"patchers"});
                Iterator it = patchers.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    boolean removed = false;
                    Iterator itPatchers = ((ArrayList)e.getValue()).iterator();
                    while (itPatchers.hasNext()) {
                        Object patcher = itPatchers.next();
                        if (!patcher.getClass().getSimpleName().equals("JarDiscovererMemoryLeakFixPatcher")) continue;
                        CoreTweaks.LOGGER.trace("Removing patcher " + patcher.getClass().getName() + " for class " + (String)e.getKey());
                        itPatchers.remove();
                        removed = true;
                    }
                    if (!removed || !((ArrayList)e.getValue()).isEmpty()) continue;
                    CoreTweaks.LOGGER.trace("Removing patcher list for class " + (String)e.getKey() + " since we emptied it.");
                    it.remove();
                }
            }
            catch (ClassNotFoundException e) {
                CoreTweaks.LOGGER.trace("Couldn't find BugfixModClassTransformer. This is not an error unless FoamFix is actually present.");
            }
        }
        catch (Exception e) {
            CoreTweaks.LOGGER.error("Failed to apply compatibility hack for FoamFix's jarDiscovererMemoryLeakFix. CoreTweaks's jar discoverer cache will be disabled. Please disable FoamFix's jarDiscovererMemoryLeakFix to fix the incompatibility.");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean isForgeSplashEnabled() {
        boolean enabled = true;
        File configFile = new File(Launch.minecraftHome, "config/splash.properties");
        if (configFile.exists()) {
            Properties props = new Properties();
            try {
                props.load(new FileReader(configFile));
                enabled = Boolean.parseBoolean((String)props.getOrDefault((Object)"enabled", "true"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return enabled;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

