/*
 * Decompiled with CFR 0.152.
 */
package serverutils.task.backup;

import java.io.File;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.ServerUtilitiesNotifications;
import serverutils.lib.data.Universe;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.ServerUtils;
import serverutils.task.Task;
import serverutils.task.backup.ThreadBackup;

public class BackupTask
extends Task {
    public static File backupsFolder;
    public static ThreadBackup thread;
    public static boolean hadPlayer;
    private ICommandSender sender;
    private String customName = "";
    private boolean post = false;

    public BackupTask(double interval) {
        super(Ticks.HOUR.x(interval));
    }

    public BackupTask(@Nullable ICommandSender ics, String customName) {
        this.customName = customName;
        this.sender = ics;
    }

    public BackupTask(boolean postCleanup) {
        super(0L);
        this.post = postCleanup;
    }

    @Override
    public boolean isRepeatable() {
        return !this.post;
    }

    @Override
    public void execute(Universe universe) {
        boolean auto;
        if (this.post) {
            this.postBackup(universe);
            return;
        }
        if (thread != null) {
            return;
        }
        boolean bl = auto = this.sender == null;
        if (auto && !ServerUtilitiesConfig.backups.enable_backups) {
            return;
        }
        MinecraftServer server = universe.server;
        if (auto && ServerUtilitiesConfig.backups.need_online_players) {
            if (!this.hasOnlinePlayers(server) && !hadPlayer) {
                return;
            }
            hadPlayer = false;
        }
        ServerUtilitiesNotifications.backupNotification(ServerUtilitiesNotifications.BACKUP_START, "cmd.backup_start", new Object[0]);
        try {
            for (int i = 0; i < server.field_71305_c.length; ++i) {
                if (server.field_71305_c[i] == null) continue;
                WorldServer worldserver = server.field_71305_c[i];
                worldserver.field_73058_d = true;
                worldserver.func_73044_a(true, null);
            }
        }
        catch (Exception ex) {
            ServerUtilities.LOGGER.info("Error while saving world: {}", new Object[]{ex.getMessage()});
        }
        File wd = server.func_130014_f_().func_72860_G().func_75765_b();
        if (ServerUtilitiesConfig.backups.use_separate_thread) {
            thread = new ThreadBackup(wd, this.customName);
            thread.start();
        } else {
            ThreadBackup.doBackup(wd, this.customName);
        }
        universe.scheduleTask(new BackupTask(true));
    }

    public static void clearOldBackups() {
        Object[] backups = backupsFolder.list();
        if (backups != null && backups.length > ServerUtilitiesConfig.backups.backups_to_keep) {
            Arrays.sort(backups);
            int toDelete = backups.length - ServerUtilitiesConfig.backups.backups_to_keep;
            ServerUtilities.LOGGER.info("Deleting {} old backups", new Object[]{toDelete});
            for (int i = 0; i < toDelete; ++i) {
                File f = new File(backupsFolder, (String)backups[i]);
                ServerUtilities.LOGGER.info("Deleted old backup: {}", new Object[]{f.getPath()});
                FileUtils.delete(f);
            }
        }
    }

    private boolean hasOnlinePlayers(MinecraftServer server) {
        return !server.func_71203_ab().field_72404_b.isEmpty();
    }

    private void postBackup(Universe universe) {
        if (thread != null && !BackupTask.thread.isDone) {
            this.setNextTime(System.currentTimeMillis() + Ticks.SECOND.millis());
            universe.scheduleTask(this);
            return;
        }
        thread = null;
        try {
            MinecraftServer server = ServerUtils.getServer();
            for (int i = 0; i < server.field_71305_c.length; ++i) {
                if (server.field_71305_c[i] == null) continue;
                WorldServer worldserver = server.field_71305_c[i];
                if (!worldserver.field_73058_d) continue;
                worldserver.field_73058_d = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        hadPlayer = false;
        File file = backupsFolder = ServerUtilitiesConfig.backups.backup_folder_path.isEmpty() ? new File("/backups/") : new File(ServerUtilitiesConfig.backups.backup_folder_path);
        if (!backupsFolder.exists()) {
            backupsFolder.mkdirs();
        }
        BackupTask.clearOldBackups();
        ServerUtilities.LOGGER.info("Backups folder - {}", new Object[]{backupsFolder.getAbsolutePath()});
    }
}

