/*
 * Decompiled with CFR 0.152.
 */
package serverutils.task;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.lib.data.Universe;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.text_components.Notification;
import serverutils.shadow.it.unimi.dsi.fastutil.ints.IntArrayList;
import serverutils.shadow.it.unimi.dsi.fastutil.ints.IntComparator;
import serverutils.shadow.it.unimi.dsi.fastutil.ints.IntListIterator;
import serverutils.task.NotifyTask;
import serverutils.task.Task;

public class ShutdownTask
extends Task {
    public static long shutdownTime = 0L;

    public ShutdownTask() {
        long now = System.currentTimeMillis();
        shutdownTime = 0L;
        Calendar calendar = Calendar.getInstance();
        int currentTime = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
        IntArrayList times = new IntArrayList(ServerUtilitiesConfig.auto_shutdown.times.length);
        for (String s0 : ServerUtilitiesConfig.auto_shutdown.times) {
            try {
                String[] s = s0.split(":", 2);
                int t = Integer.parseInt(s[0]) * 3600 + Integer.parseInt(s[1]) * 60;
                if (t <= currentTime) {
                    t += 86400;
                }
                times.add(t);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        times.sort((IntComparator)null);
        IntListIterator intListIterator = times.iterator();
        while (intListIterator.hasNext()) {
            int time = (Integer)intListIterator.next();
            if (time <= currentTime) continue;
            shutdownTime = now + (long)(time - currentTime) * Ticks.SECOND.millis();
            break;
        }
    }

    @Override
    public long getNextTime() {
        return shutdownTime;
    }

    @Override
    public void execute(Universe universe) {
        FileUtils.newFile(universe.server.func_71209_f("autostart.stamp"));
        universe.server.func_71263_m();
    }

    @Override
    public List<NotifyTask> getNotifications() {
        ArrayList<NotifyTask> notifications = new ArrayList<NotifyTask>();
        long now = System.currentTimeMillis();
        if (shutdownTime > 0L) {
            Ticks[] ticks;
            ServerUtilities.LOGGER.info("Server will shut down in {}", new Object[]{StringUtils.getTimeString(shutdownTime - now)});
            for (Ticks t : ticks = new Ticks[]{Ticks.MINUTE.x(30L), Ticks.MINUTE.x(10L), Ticks.MINUTE.x(5L), Ticks.MINUTE.x(1L), Ticks.SECOND.x(10L), Ticks.SECOND.x(9L), Ticks.SECOND.x(8L), Ticks.SECOND.x(7L), Ticks.SECOND.x(6L), Ticks.SECOND.x(5L), Ticks.SECOND.x(4L), Ticks.SECOND.x(3L), Ticks.SECOND.x(2L), Ticks.SECOND.x(1L)}) {
                IChatComponent component = StringUtils.color((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"serverutilities.lang.timer.shutdown", (Object[])new Object[]{t.toTimeString()})), EnumChatFormatting.LIGHT_PURPLE);
                Notification notification = Notification.of("restart_timer", component);
                NotifyTask task = new NotifyTask(shutdownTime - t.millis(), notification);
                notifications.add(task);
            }
        }
        return notifications;
    }
}

