/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.client.gui.GuiLeaderboard;
import serverutils.data.Leaderboard;
import serverutils.data.LeaderboardValue;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.Universe;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.NetworkWrapper;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageLeaderboardResponse
extends MessageToClient {
    private static final DataOut.Serializer<LeaderboardValue> VALUE_SERIALIZER = (data, object) -> {
        data.writeString(object.username);
        data.writeTextComponent(object.value);
        data.writeByte(object.color.ordinal());
    };
    private static final DataIn.Deserializer<LeaderboardValue> VALUE_DESERIALIZER = data -> {
        LeaderboardValue value = new LeaderboardValue();
        value.username = data.readString();
        value.value = data.readTextComponent();
        value.color = EnumChatFormatting.values()[data.readUnsignedByte()];
        return value;
    };
    private IChatComponent title;
    private List<LeaderboardValue> values;

    public MessageLeaderboardResponse() {
    }

    public MessageLeaderboardResponse(EntityPlayerMP player, Leaderboard leaderboard) {
        this.title = leaderboard.getTitle();
        this.values = new ArrayList<LeaderboardValue>();
        ForgePlayer p0 = Universe.get().getPlayer((ICommandSender)player);
        ArrayList<ForgePlayer> players = new ArrayList<ForgePlayer>(Universe.get().getPlayers());
        players.sort(leaderboard.getComparator());
        for (int i = 0; i < players.size(); ++i) {
            ForgePlayer p = (ForgePlayer)players.get(i);
            LeaderboardValue value = new LeaderboardValue();
            value.username = p.getDisplayNameString();
            value.value = leaderboard.createValue(p);
            value.color = p == p0 ? EnumChatFormatting.DARK_GREEN : (!leaderboard.hasValidValue(p) ? EnumChatFormatting.DARK_GRAY : (i < 3 ? EnumChatFormatting.GOLD : EnumChatFormatting.RESET));
            this.values.add(value);
        }
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.STATS;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeTextComponent(this.title);
        data.writeCollection(this.values, VALUE_SERIALIZER);
    }

    @Override
    public void readData(DataIn data) {
        this.title = data.readTextComponent();
        this.values = new ArrayList<LeaderboardValue>();
        data.readCollection(this.values, VALUE_DESERIALIZER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        new GuiLeaderboard(this.title, this.values).openGui();
    }
}

