/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import serverutils.client.gui.ClientClaimedChunks;
import serverutils.data.ClaimedChunk;
import serverutils.data.ClaimedChunks;
import serverutils.data.ServerUtilitiesTeamData;
import serverutils.events.chunks.UpdateClientDataEvent;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.data.Universe;
import serverutils.lib.io.Bits;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.NetworkWrapper;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageClaimedChunksUpdate
extends MessageToClient {
    public int startX;
    public int startZ;
    public int claimedChunks;
    public int loadedChunks;
    public int maxClaimedChunks;
    public int maxLoadedChunks;
    public Map<Short, ClientClaimedChunks.Team> teams;

    public MessageClaimedChunksUpdate() {
    }

    public MessageClaimedChunksUpdate(int sx, int sz, EntityPlayer player) {
        this.startX = sx;
        this.startZ = sz;
        ForgePlayer p = Universe.get().getPlayer((ICommandSender)player);
        ServerUtilitiesTeamData teamData = ServerUtilitiesTeamData.get(p.team);
        List<ClaimedChunk> chunks = teamData.team.isValid() ? ClaimedChunks.instance.getTeamChunks(teamData.team, OptionalInt.empty()) : Collections.emptyList();
        this.claimedChunks = chunks.size();
        this.loadedChunks = 0;
        for (ClaimedChunk c : chunks) {
            if (!c.isLoaded()) continue;
            ++this.loadedChunks;
        }
        this.maxClaimedChunks = this.getMaxClaimedChunks(teamData, p);
        this.maxLoadedChunks = teamData.getMaxChunkloaderChunks();
        this.teams = new HashMap<Short, ClientClaimedChunks.Team>();
        boolean canSeeChunkInfo = PermissionAPI.hasPermission(player, "serverutilities.other_player.claims.see_info");
        for (int x1 = 0; x1 < 15; ++x1) {
            for (int z1 = 0; z1 < 15; ++z1) {
                ForgeTeam chunkTeam;
                ChunkDimPos pos = new ChunkDimPos(this.startX + x1, this.startZ + z1, player.field_71093_bK);
                ClaimedChunk chunk = ClaimedChunks.instance.getChunk(pos);
                if (chunk == null || !(chunkTeam = chunk.getTeam()).isValid()) continue;
                ClientClaimedChunks.Team team = this.teams.get(chunkTeam.getUID());
                if (team == null) {
                    team = new ClientClaimedChunks.Team(chunkTeam.getUID());
                    team.color = chunkTeam.getColor();
                    team.nameComponent = chunkTeam.getTitle();
                    team.isAlly = chunkTeam.isAlly(p);
                    this.teams.put(chunkTeam.getUID(), team);
                }
                boolean member = chunkTeam.isMember(p);
                int flags = 0;
                if ((canSeeChunkInfo || member) && chunk.isLoaded()) {
                    flags = Bits.setFlag(flags, 1, true);
                }
                team.chunks.put(x1 + z1 * 15, new ClientClaimedChunks.ChunkData(team, flags));
            }
        }
    }

    private int getMaxClaimedChunks(ServerUtilitiesTeamData teamData, ForgePlayer player) {
        if (teamData.getMaxClaimChunks() < 0) {
            return teamData.getMaxClaimChunks();
        }
        return player.hasPermission("serverutilities.claims.bypass_limits") ? Integer.MAX_VALUE : teamData.getMaxClaimChunks();
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.CLAIMS;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeVarInt(this.startX);
        data.writeVarInt(this.startZ);
        data.writeVarInt(this.claimedChunks);
        data.writeVarInt(this.loadedChunks);
        data.writeVarInt(this.maxClaimedChunks);
        data.writeVarInt(this.maxLoadedChunks);
        data.writeCollection(this.teams.values(), ClientClaimedChunks.Team.SERIALIZER);
    }

    @Override
    public void readData(DataIn data) {
        this.startX = data.readVarInt();
        this.startZ = data.readVarInt();
        this.claimedChunks = data.readVarInt();
        this.loadedChunks = data.readVarInt();
        this.maxClaimedChunks = data.readVarInt();
        this.maxLoadedChunks = data.readVarInt();
        this.teams = new HashMap<Short, ClientClaimedChunks.Team>();
        for (ClientClaimedChunks.Team team : data.readCollection(ClientClaimedChunks.Team.DESERIALIZER)) {
            this.teams.put(team.uid, team);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        new UpdateClientDataEvent(this).post();
    }
}

