/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.gui.misc;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.gui.Button;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.SimpleTextButton;
import serverutils.lib.gui.TextBox;
import serverutils.lib.gui.WidgetType;
import serverutils.lib.gui.misc.IConfigValueEditCallback;
import serverutils.lib.icon.Icon;
import serverutils.lib.util.misc.MouseButton;

public class GuiEditConfigValue
extends GuiBase {
    private final ConfigValueInstance inst;
    private final ConfigValue value;
    private final IConfigValueEditCallback callback;
    private final Button buttonCancel;
    private final Button buttonAccept;
    private final TextBox textBox;

    public GuiEditConfigValue(ConfigValueInstance val, IConfigValueEditCallback c) {
        this.setSize(230, 54);
        this.inst = val;
        this.value = this.inst.getValue().copy();
        this.callback = c;
        int bsize = this.width / 2 - 10;
        this.buttonCancel = new SimpleTextButton(this, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                GuiEditConfigValue.this.callback.onCallback(GuiEditConfigValue.this.inst.getValue(), false);
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonCancel.setPosAndSize(8, this.height - 24, bsize, 16);
        this.buttonAccept = new SimpleTextButton(this, I18n.func_135052_a((String)"gui.accept", (Object[])new Object[0]), Icon.EMPTY){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                if (GuiEditConfigValue.this.value.setValueFromString((ICommandSender)Minecraft.func_71410_x().field_71439_g, GuiEditConfigValue.this.textBox.getText(), false)) {
                    GuiEditConfigValue.this.callback.onCallback(GuiEditConfigValue.this.value, true);
                }
                if (this.getGui().parent instanceof GuiBase) {
                    this.getGui().parent.closeContextMenu();
                }
            }

            @Override
            public WidgetType getWidgetType() {
                return GuiEditConfigValue.this.inst.getCanEdit() && GuiEditConfigValue.this.textBox.isTextValid() ? super.getWidgetType() : WidgetType.DISABLED;
            }

            @Override
            public boolean renderTitleInCenter() {
                return true;
            }
        };
        this.buttonAccept.setPosAndSize(this.width - bsize - 8, this.height - 24, bsize, 16);
        this.textBox = new TextBox(this){

            @Override
            public boolean allowInput() {
                return GuiEditConfigValue.this.inst.getCanEdit();
            }

            @Override
            public boolean isValid(String txt) {
                return GuiEditConfigValue.this.value.setValueFromString((ICommandSender)Minecraft.func_71410_x().field_71439_g, txt, true);
            }

            @Override
            public void onTextChanged() {
                ((GuiEditConfigValue)GuiEditConfigValue.this).textBox.textColor = GuiEditConfigValue.this.value.getColor();
            }

            @Override
            public void onEnterPressed() {
                if (GuiEditConfigValue.this.inst.getCanEdit()) {
                    GuiEditConfigValue.this.buttonAccept.onClicked(MouseButton.LEFT);
                }
            }
        };
        this.textBox.setPosAndSize(8, 8, this.width - 16, 16);
        this.textBox.setText(this.value.getString());
        this.textBox.setCursorPosition(this.textBox.getText().length());
        this.textBox.setFocused(true);
    }

    public GuiEditConfigValue(String name, ConfigValue val, IConfigValueEditCallback c) {
        this(new ConfigValueInstance(name, ConfigGroup.DEFAULT, val), c);
    }

    @Override
    public boolean onClosedByKey(int key) {
        if (super.onClosedByKey(key)) {
            this.callback.onCallback(this.inst.getValue(), false);
            return false;
        }
        return false;
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonCancel);
        this.add(this.buttonAccept);
        this.add(this.textBox);
    }

    @Override
    public boolean doesGuiPauseGame() {
        GuiScreen screen = this.getPrevScreen();
        return screen != null && screen.func_73868_f();
    }
}

