/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.data;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesCommon;
import serverutils.ServerUtilitiesConfig;
import serverutils.ServerUtilitiesNotifications;
import serverutils.events.IReloadHandler;
import serverutils.events.ServerReloadEvent;
import serverutils.lib.EnumReloadType;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.config.ConfigNull;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.ConfigValueProvider;
import serverutils.lib.config.IConfigCallback;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.Universe;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.text_components.Notification;
import serverutils.net.MessageCloseGui;
import serverutils.net.MessageEditConfig;
import serverutils.net.MessageSyncData;

public class ServerUtilitiesAPI {
    public static void reloadServer(Universe universe, ICommandSender sender, EnumReloadType type, ResourceLocation id) {
        long ms = System.currentTimeMillis();
        universe.clearCache();
        HashSet<ResourceLocation> failed = new HashSet<ResourceLocation>();
        ServerReloadEvent event = new ServerReloadEvent(universe, sender, type, id, failed);
        for (Map.Entry<ResourceLocation, IReloadHandler> entry : ServerUtilitiesCommon.RELOAD_IDS.entrySet()) {
            try {
                if (!event.reload(entry.getKey()) || entry.getValue().onReload(event)) continue;
                event.failedToReload(entry.getKey());
            }
            catch (Exception ex) {
                event.failedToReload(entry.getKey());
                if (!ServerUtilitiesConfig.debugging.print_more_errors) continue;
                ex.printStackTrace();
            }
        }
        event.post();
        for (EntityPlayerMP player : universe.server.func_71203_ab().field_72404_b) {
            ForgePlayer p = universe.getPlayer((ICommandSender)player);
            new MessageSyncData(false, player, p).sendTo(player);
        }
        String millis = System.currentTimeMillis() - ms + "ms";
        if (type == EnumReloadType.RELOAD_COMMAND) {
            for (EntityPlayerMP player : universe.server.func_71203_ab().field_72404_b) {
                Notification notification = Notification.of(ServerUtilitiesNotifications.RELOAD_SERVER, new IChatComponent[0]);
                notification.addLine(ServerUtilities.lang((ICommandSender)player, "serverutilities.lang.reload_server", millis));
                if (event.isClientReloadRequired()) {
                    notification.addLine(ServerUtilities.lang((ICommandSender)player, "serverutilities.lang.reload_client", StringUtils.color((IChatComponent)new ChatComponentText("F3 + T"), EnumChatFormatting.GOLD)));
                }
                if (!failed.isEmpty()) {
                    notification.addLine(StringUtils.color(ServerUtilities.lang((ICommandSender)player, "serverutilities.lang.reload_failed", new Object[0]), EnumChatFormatting.RED));
                    ServerUtilities.LOGGER.warn("These IDs failed to reload:");
                    for (ResourceLocation f : failed) {
                        notification.addLine(StringUtils.color((IChatComponent)new ChatComponentText(f.toString()), EnumChatFormatting.RED));
                        ServerUtilities.LOGGER.warn("- " + f);
                    }
                }
                notification.setImportant(true);
                notification.setTimer(Ticks.SECOND.x(7L));
                notification.send(universe.server, (EntityPlayer)player);
            }
        }
        ServerUtilitiesAPI.reload(universe.server);
        ServerUtilities.LOGGER.info("Reloaded server in " + millis);
    }

    public static void editServerConfig(EntityPlayerMP player, ConfigGroup group, IConfigCallback callback) {
        ServerUtilitiesCommon.TEMP_SERVER_CONFIG.put(player.func_146103_bH().getId(), new ServerUtilitiesCommon.EditingConfig(group, callback));
        new MessageEditConfig(group).sendTo(player);
    }

    public static ConfigValue createConfigValueFromId(String id) {
        if (id.isEmpty()) {
            return ConfigNull.INSTANCE;
        }
        ConfigValueProvider provider = ServerUtilitiesCommon.CONFIG_VALUE_PROVIDERS.get(id);
        Objects.requireNonNull(provider, "Unknown Config ID: " + id);
        ConfigValue value = (ConfigValue)provider.get();
        return value == null || value.isNull() ? ConfigNull.INSTANCE : value;
    }

    public static void sendCloseGuiPacket(EntityPlayerMP player) {
        new MessageCloseGui().sendTo(player);
    }

    public static boolean arePlayersInSameTeam(UUID player1, UUID player2) {
        if (!Universe.loaded()) {
            return false;
        }
        if (player1 == player2 || player1.equals(player2)) {
            return true;
        }
        ForgePlayer p1 = Universe.get().getPlayer(player1);
        if (p1 == null || !p1.hasTeam()) {
            return false;
        }
        ForgePlayer p2 = Universe.get().getPlayer(player2);
        return p2 != null && p2.hasTeam() && p1.team.equalsTeam(p2.team);
    }

    public static boolean isPlayerInTeam(UUID player, String team) {
        if (!Universe.loaded()) {
            return false;
        }
        ForgePlayer p = Universe.get().getPlayer(player);
        if (p == null) {
            return false;
        }
        return p.hasTeam() ? p.team.getId().equals(team) : team.isEmpty();
    }

    public static boolean isPlayerInTeam(UUID player, int team) {
        if (!Universe.loaded()) {
            return false;
        }
        ForgePlayer p = Universe.get().getPlayer(player);
        if (p == null) {
            return false;
        }
        return p.hasTeam() ? p.team.getUID() == team : team == 0;
    }

    public static String getTeam(UUID player) {
        if (!Universe.loaded()) {
            return "";
        }
        ForgePlayer p = Universe.get().getPlayer(player);
        return p == null ? "" : p.team.getId();
    }

    public static short getTeamID(UUID player) {
        if (!Universe.loaded()) {
            return 0;
        }
        ForgePlayer p = Universe.get().getPlayer(player);
        return p == null ? (short)0 : p.team.getUID();
    }

    public static void reload(MinecraftServer server) {
        if (Thread.currentThread().getName().equals("Server thread")) {
            server.func_71203_ab().func_72389_g();
        }
    }
}

