/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.config;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.lib.config.ConfigEnum;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.config.IIteratingConfig;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.IOpenableGui;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.SimpleTextButton;
import serverutils.lib.gui.misc.GuiButtonListBase;
import serverutils.lib.icon.Color4I;
import serverutils.lib.icon.Icon;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.math.MathUtils;
import serverutils.lib.util.misc.MouseButton;

public class ConfigStringEnum
extends ConfigValue
implements IIteratingConfig {
    private final List<StringEnumValue> values;
    private StringEnumValue value;

    public ConfigStringEnum(List<String> k, String v) {
        this.values = new ArrayList<StringEnumValue>(k.size());
        for (int i = 0; i < k.size(); ++i) {
            this.values.add(new StringEnumValue(i, k.get(i)));
        }
        this.value = this.get(v);
    }

    private ConfigStringEnum(ConfigStringEnum copyFrom) {
        this.values = new ArrayList<StringEnumValue>(copyFrom.values.size());
        for (int i = 0; i < copyFrom.values.size(); ++i) {
            StringEnumValue v0 = copyFrom.values.get(i);
            StringEnumValue v = new StringEnumValue(i, v0.id);
            v.customName = v0.customName == null ? null : v0.customName.func_150259_f();
            v.customColor = v0.customColor.copy();
            this.values.add(v);
        }
        this.setString(copyFrom.getString());
    }

    @Nullable
    public StringEnumValue get(String v) {
        if (v.isEmpty()) {
            return null;
        }
        for (StringEnumValue value : this.values) {
            if (!value.id.equals(v)) continue;
            return value;
        }
        return null;
    }

    @Override
    public String getId() {
        return "enum";
    }

    public void setString(String v) {
        this.value = this.get(v);
    }

    @Override
    public String getString() {
        return this.value == null ? "" : this.value.id;
    }

    @Override
    public IChatComponent getStringForGUI() {
        return this.value == null ? new ChatComponentText("null") : (this.value.customName == null ? new ChatComponentText(this.getString()) : this.value.customName.func_150259_f());
    }

    @Override
    public boolean getBoolean() {
        return true;
    }

    @Override
    public int getInt() {
        return this.value == null ? -1 : this.value.index;
    }

    @Override
    public ConfigStringEnum copy() {
        return new ConfigStringEnum(this);
    }

    @Override
    public Color4I getColor() {
        return this.value == null || this.value.customColor.isEmpty() ? ConfigEnum.COLOR : this.value.customColor;
    }

    @Override
    public void addInfo(ConfigValueInstance inst, List<String> list) {
        if (inst.getCanEdit() && !inst.getDefaultValue().isNull()) {
            StringEnumValue value = this.get(inst.getDefaultValue().getString());
            IChatComponent component = value == null ? null : value.customName;
            list.add(EnumChatFormatting.AQUA + "Default: " + EnumChatFormatting.RESET + (component == null ? inst.getDefaultValue() : component.func_150254_d()));
        }
        list.add("");
        for (StringEnumValue v : this.values) {
            list.add((v == this.value ? EnumChatFormatting.AQUA + "+ " : EnumChatFormatting.DARK_GRAY + "- ") + (v.customName == null ? v.id : v.customName.func_150260_c()));
        }
    }

    @Override
    public void onClicked(final IOpenableGui gui, ConfigValueInstance inst, MouseButton button, final Runnable callback) {
        if (this.values.size() > 16 || GuiBase.isCtrlKeyDown()) {
            GuiButtonListBase g = new GuiButtonListBase(){

                @Override
                public void addButtons(Panel panel) {
                    for (final StringEnumValue v : ConfigStringEnum.this.values) {
                        panel.add(new SimpleTextButton(panel, v.customName == null ? ConfigStringEnum.this.getString() : v.customName.func_150260_c(), Icon.EMPTY){

                            @Override
                            public void onClicked(MouseButton button) {
                                GuiHelper.playClickSound();
                                ConfigStringEnum.this.setString(v.id);
                                gui.openGui();
                                callback.run();
                            }
                        });
                    }
                }
            };
            g.setHasSearchBox(true);
            g.openGui();
            return;
        }
        super.onClicked(gui, inst, button, callback);
    }

    @Override
    public List<String> getVariants() {
        ArrayList<String> l = new ArrayList<String>(this.values.size());
        for (StringEnumValue v : this.values) {
            l.add(v.id);
        }
        return l;
    }

    @Override
    public ConfigValue getIteration(boolean next) {
        ConfigStringEnum c = this.copy();
        c.setString(this.value == null ? "" : c.values.get((int)MathUtils.mod((int)(c.value.index + (next ? 1 : -1)), (int)c.values.size())).id);
        return c;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        nbt.func_74778_a(key, this.getString());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.setString(nbt.func_74779_i(key));
    }

    @Override
    public void writeData(DataOut data) {
        data.writeVarInt(this.values.size());
        for (StringEnumValue v : this.values) {
            data.writeString(v.id);
            data.writeTextComponent(v.customName);
            data.writeInt(v.customColor.rgba());
        }
        data.writeString(this.getString());
    }

    @Override
    public void readData(DataIn data) {
        this.values.clear();
        int s = data.readVarInt();
        for (int i = 0; i < s; ++i) {
            StringEnumValue v = new StringEnumValue(i, data.readString());
            v.customName = data.readTextComponent();
            v.customColor = Color4I.rgba(data.readInt());
            this.values.add(v);
        }
        this.setString(data.readString());
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        this.setString(string);
        return true;
    }

    @Override
    public void setValueFromOtherValue(ConfigValue value) {
        this.setString(value.getString());
    }

    public static final class StringEnumValue {
        public final int index;
        public final String id;
        public IChatComponent customName = null;
        public Color4I customColor = Icon.EMPTY;

        public StringEnumValue(int idx, String i) {
            this.index = idx;
            this.id = i;
        }

        public int hashCode() {
            return this.index;
        }

        public boolean equals(Object o) {
            return o == this || this.index == o.hashCode();
        }

        public String toString() {
            return this.id;
        }
    }
}

