/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.config;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import serverutils.lib.config.ConfigInt;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.icon.Color4I;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.util.StringUtils;

public class ConfigDouble
extends ConfigValue
implements DoubleSupplier {
    public static final String ID = "double";
    private double value;
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;

    public ConfigDouble(double v) {
        this.value = v;
    }

    public ConfigDouble(double v, double mn, double mx) {
        this(MathHelper.func_151237_a((double)v, (double)mn, (double)mx));
        this.min = mn;
        this.max = mx;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    public void setDouble(double v) {
        this.value = MathHelper.func_151237_a((double)v, (double)this.getMin(), (double)this.getMax());
    }

    public ConfigDouble setMin(double v) {
        this.min = v;
        return this;
    }

    public ConfigDouble setMax(double v) {
        this.max = v;
        return this;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    @Override
    public String getString() {
        String s = Double.toString(this.getDouble());
        return s.endsWith(".0") ? s.substring(0, s.length() - 2) : s;
    }

    @Override
    public IChatComponent getStringForGUI() {
        return new ChatComponentText(StringUtils.formatDouble(this.getDouble(), true));
    }

    @Override
    public boolean getBoolean() {
        return this.getDouble() != 0.0;
    }

    @Override
    public int getInt() {
        return (int)this.getDouble();
    }

    @Override
    public long getLong() {
        return (long)this.getDouble();
    }

    @Override
    public ConfigDouble copy() {
        return new ConfigDouble(this.getDouble(), this.getMin(), this.getMax());
    }

    @Override
    public boolean equalsValue(ConfigValue value) {
        return this.getDouble() == value.getDouble();
    }

    @Override
    public Color4I getColor() {
        return ConfigInt.COLOR;
    }

    @Override
    public void addInfo(ConfigValueInstance inst, List<String> list) {
        super.addInfo(inst, list);
        double min = this.getMin();
        double max = this.getMax();
        if (min != Double.NEGATIVE_INFINITY) {
            list.add(EnumChatFormatting.AQUA + "Min: " + EnumChatFormatting.RESET + StringUtils.formatDouble(min));
        }
        if (max != Double.POSITIVE_INFINITY) {
            list.add(EnumChatFormatting.AQUA + "Max: " + EnumChatFormatting.RESET + StringUtils.formatDouble(max));
        }
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        if (string.isEmpty()) {
            return false;
        }
        double min = this.getMin();
        double max = this.getMax();
        if (string.equals("+Inf")) {
            if (max != Double.POSITIVE_INFINITY) {
                return false;
            }
            if (!simulate) {
                this.setDouble(Double.POSITIVE_INFINITY);
            }
            return true;
        }
        if (string.equals("-Inf")) {
            if (min != Double.NEGATIVE_INFINITY) {
                return false;
            }
            if (!simulate) {
                this.setDouble(Double.NEGATIVE_INFINITY);
            }
            return true;
        }
        try {
            double multiplier = 1.0;
            if (string.endsWith("K")) {
                multiplier = 1000.0;
                string = string.substring(0, string.length() - 1);
            } else if (string.endsWith("M")) {
                multiplier = 1000000.0;
                string = string.substring(0, string.length() - 1);
            } else if (string.endsWith("B")) {
                multiplier = 1.0E9;
                string = string.substring(0, string.length() - 1);
            }
            double val = Double.parseDouble(string.trim()) * multiplier;
            if (val < min || val > max) {
                return false;
            }
            if (!simulate) {
                this.setDouble(val);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        this.value = this.getDouble();
        if (this.value != 0.0) {
            nbt.func_74780_a(key, this.value);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.setDouble(nbt.func_74769_h(key));
    }

    @Override
    public void writeData(DataOut data) {
        data.writeDouble(this.getDouble());
        data.writeDouble(this.getMin());
        data.writeDouble(this.getMax());
    }

    @Override
    public void readData(DataIn data) {
        this.setDouble(data.readDouble());
        this.setMin(data.readDouble());
        this.setMax(data.readDouble());
    }

    @Override
    public double getAsDouble() {
        return this.getDouble();
    }

    @Override
    public void setValueFromOtherValue(ConfigValue value) {
        this.setDouble(value.getDouble());
    }

    @Override
    public void setValueFromJson(JsonElement json) {
        if (json.isJsonPrimitive()) {
            this.setDouble(json.getAsDouble());
        }
    }

    public static class SimpleDouble
    extends ConfigDouble {
        private final DoubleSupplier get;
        private final DoubleConsumer set;

        public SimpleDouble(double min, double max, DoubleSupplier g, DoubleConsumer s) {
            super(0.0, min, max);
            this.get = g;
            this.set = s;
        }

        @Override
        public double getDouble() {
            return this.get.getAsDouble();
        }

        @Override
        public void setDouble(double v) {
            this.set.accept(v);
        }
    }
}

