/*
 * Decompiled with CFR 0.152.
 */
package serverutils.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import serverutils.events.ServerUtilitiesPreInitRegistryEvent;
import serverutils.handlers.ServerUtilitiesSyncData;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.config.IConfigCallback;
import serverutils.lib.data.Action;
import serverutils.lib.data.AdminPanelAction;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ServerUtilitiesAPI;
import serverutils.lib.gui.GuiIcons;
import serverutils.lib.icon.ItemIcon;
import serverutils.lib.util.StringUtils;
import serverutils.net.MessageViewCrashList;
import serverutils.ranks.Ranks;

public class ServerUtilitiesRegistryEventHandler {
    public static final ServerUtilitiesRegistryEventHandler INST = new ServerUtilitiesRegistryEventHandler();

    @SubscribeEvent
    public void onServerUtilitiesPreInitRegistry(ServerUtilitiesPreInitRegistryEvent event) {
        ServerUtilitiesPreInitRegistryEvent.Registry registry = event.getRegistry();
        registry.registerServerReloadHandler(new ResourceLocation("serverutilities", "ranks"), reloadEvent -> Ranks.INSTANCE.reload());
        registry.registerSyncData("serverutilities", new ServerUtilitiesSyncData());
        registry.registerAdminPanelAction(new AdminPanelAction("serverutilities", "crash_reports", ItemIcon.getItemIcon(Item.func_150899_d((int)339)), 0){

            @Override
            public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
                return Action.Type.fromBoolean(player.hasPermission("admin_panel.serverutilities.crash_reports.view"));
            }

            @Override
            public void onAction(ForgePlayer player, NBTTagCompound data) {
                new MessageViewCrashList(player.team.universe.server.func_71209_f("crash-reports")).sendTo(player.getPlayer());
            }
        });
        registry.registerAdminPanelAction(new AdminPanelAction("serverutilities", "edit_world", GuiIcons.GLOBE, 0){

            @Override
            public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
                return Action.Type.fromBoolean(player.hasPermission("admin_panel.serverutilities.edit_world.gamerules"));
            }

            @Override
            public void onAction(ForgePlayer player, NBTTagCompound data) {
                ConfigGroup main = ConfigGroup.newGroup("edit_world");
                main.setDisplayName((IChatComponent)new ChatComponentTranslation("admin_panel.serverutilities.edit_world", new Object[0]));
                if (player.hasPermission("admin_panel.serverutilities.edit_world.gamerules")) {
                    ConfigGroup gamerules = main.getGroup("gamerules");
                    gamerules.setDisplayName((IChatComponent)new ChatComponentTranslation("gamerules", new Object[0]));
                    GameRules rules = player.team.universe.world.func_82736_K();
                    for (String key : rules.func_82763_b()) {
                        String value = rules.func_82767_a(key);
                        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                            gamerules.addBool(key, () -> rules.func_82766_b(key), v -> rules.func_82764_b(key, Boolean.toString(v)), false).setDisplayName((IChatComponent)new ChatComponentText(StringUtils.camelCaseToWords(key)));
                            continue;
                        }
                        try {
                            Integer.parseInt(value);
                            gamerules.addInt(key, () -> Integer.parseInt(rules.func_82767_a(key)), v -> rules.func_82764_b(key, Integer.toString(v)), 1, 1, Integer.MAX_VALUE).setDisplayName((IChatComponent)new ChatComponentText(StringUtils.camelCaseToWords(key)));
                        }
                        catch (NumberFormatException ignored) {
                            gamerules.addString(key, () -> rules.func_82767_a(key), v -> rules.func_82764_b(key, v), "").setDisplayName((IChatComponent)new ChatComponentText(StringUtils.camelCaseToWords(key)));
                        }
                    }
                }
                ServerUtilitiesAPI.editServerConfig(player.getPlayer(), main, IConfigCallback.DEFAULT);
            }
        });
    }
}

