/*
 * Decompiled with CFR 0.152.
 */
package serverutils.data;

import java.util.Comparator;
import net.minecraft.nbt.NBTTagCompound;
import serverutils.data.TeleportType;
import serverutils.lib.math.BlockDimPos;
import serverutils.lib.math.TeleporterDimPos;
import serverutils.lib.util.INBTSerializable;

public class TeleportLog
implements INBTSerializable<NBTTagCompound>,
Comparable<TeleportLog> {
    private static final String NBT_KEY_X = "x";
    private static final String NBT_KEY_Y = "y";
    private static final String NBT_KEY_Z = "z";
    private static final String NBT_KEY_DIMENSION = "dimension";
    private static final String NBT_KEY_TELEPORT_TYPE = "teleport_type";
    private static final String NBT_KEY_CREATED_AT = "created_at";
    private static Comparator<TeleportLog> comparator = Comparator.comparing(log -> log == null ? null : Long.valueOf(log.getCreatedAt()), Comparator.nullsFirst(Long::compareTo));
    public TeleportType teleportType;
    private BlockDimPos from;
    private long createdAt;

    public TeleportLog(NBTTagCompound nbt) {
        this.deserializeNBT(nbt);
    }

    public TeleportLog(TeleportType teleportType, BlockDimPos from, long createdAt) {
        this.teleportType = teleportType;
        this.from = from;
        this.createdAt = createdAt;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a(NBT_KEY_DIMENSION, this.from.dim);
        nbt.func_74768_a(NBT_KEY_X, this.from.posX);
        nbt.func_74768_a(NBT_KEY_Y, this.from.posY);
        nbt.func_74768_a(NBT_KEY_Z, this.from.posZ);
        nbt.func_74768_a(NBT_KEY_TELEPORT_TYPE, this.teleportType.ordinal());
        nbt.func_74772_a(NBT_KEY_CREATED_AT, this.createdAt);
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        int posX = nbt.func_74762_e(NBT_KEY_X);
        int posY = nbt.func_74762_e(NBT_KEY_Y);
        int posZ = nbt.func_74762_e(NBT_KEY_Z);
        int dimension = nbt.func_74762_e(NBT_KEY_DIMENSION);
        int teleportType = nbt.func_74762_e(NBT_KEY_TELEPORT_TYPE);
        this.from = new BlockDimPos(posX, posY, posZ, dimension);
        this.teleportType = TeleportType.values()[teleportType];
    }

    public BlockDimPos getBlockDimPos() {
        return this.from;
    }

    public TeleporterDimPos teleporter() {
        return this.getBlockDimPos().teleporter();
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public int compareTo(TeleportLog o) {
        return comparator.compare(this, o);
    }
}

