/*
 * Decompiled with CFR 0.152.
 */
package serverutils.data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.data.ClaimedChunk;
import serverutils.data.TicketKey;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.util.ServerUtils;

public class ServerUtilitiesLoadedChunkManager
implements ForgeChunkManager.LoadingCallback {
    public static final ServerUtilitiesLoadedChunkManager INSTANCE = new ServerUtilitiesLoadedChunkManager();
    public final Map<TicketKey, ForgeChunkManager.Ticket> ticketMap = new HashMap<TicketKey, ForgeChunkManager.Ticket>();
    private final Map<ChunkDimPos, ForgeChunkManager.Ticket> chunkTickets = new HashMap<ChunkDimPos, ForgeChunkManager.Ticket>();

    public void clear() {
        this.ticketMap.clear();
        this.chunkTickets.clear();
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        int dim = world.field_73011_w.field_76574_g;
        for (ForgeChunkManager.Ticket ticket : tickets) {
            TicketKey key = new TicketKey(dim, ticket.getModData().func_74779_i("Team"));
            if (key.teamId.isEmpty()) continue;
            if (!ticket.getChunkList().isEmpty()) {
                this.ticketMap.put(key, ticket);
            }
            for (ChunkCoordIntPair pos : ticket.getChunkList()) {
                this.chunkTickets.put(new ChunkDimPos(pos, key.dimension), ticket);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)pos);
            }
        }
    }

    @Nullable
    public ForgeChunkManager.Ticket requestTicket(MinecraftServer server, TicketKey key) {
        WorldServer worldServer;
        ForgeChunkManager.Ticket ticket = this.ticketMap.get(key);
        if (ticket == null && DimensionManager.isDimensionRegistered((int)key.dimension) && (ticket = ForgeChunkManager.requestTicket((Object)ServerUtilities.INST, (World)(worldServer = server.func_71218_a(key.dimension)), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL)) != null) {
            this.ticketMap.put(key, ticket);
            ticket.getModData().func_74778_a("Team", key.teamId);
        }
        return ticket;
    }

    public void forceChunk(MinecraftServer server, ClaimedChunk chunk) {
        block7: {
            if (chunk.forced != null && chunk.forced.booleanValue()) {
                return;
            }
            ChunkDimPos pos = chunk.getPos();
            ForgeChunkManager.Ticket ticket = this.requestTicket(server, new TicketKey(pos.dim, chunk.getTeam().getId()));
            try {
                Objects.requireNonNull(ticket);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)pos.getChunkPos());
                chunk.forced = true;
                this.chunkTickets.put(pos, ticket);
                if (ServerUtilitiesConfig.debugging.log_chunkloading) {
                    ServerUtilities.LOGGER.info(chunk.getTeam().getTitle().func_150260_c() + " forced " + pos.posX + "," + pos.posZ + " in " + ServerUtils.getDimensionName(pos.dim).func_150260_c());
                }
            }
            catch (Exception ex) {
                if (!DimensionManager.isDimensionRegistered((int)chunk.getPos().dim)) {
                    ServerUtilities.LOGGER.error("Failed to force chunk " + pos.posX + "," + pos.posZ + " in " + ServerUtils.getDimensionName(pos.dim).func_150260_c() + " from " + chunk.getTeam().getTitle().func_150260_c() + ": Dimension " + chunk.getPos().dim + " not registered!");
                } else {
                    ServerUtilities.LOGGER.error("Failed to force chunk " + pos.posX + "," + pos.posZ + " in " + ServerUtils.getDimensionName(pos.dim).func_150260_c() + " from " + chunk.getTeam().getTitle().func_150260_c() + ": " + ex);
                    if (ServerUtilitiesConfig.debugging.print_more_errors) {
                        ex.printStackTrace();
                    }
                }
                if (!ServerUtilitiesConfig.world.unload_erroring_chunks) break block7;
                ServerUtilities.LOGGER.warn("Unloading erroring chunk at " + pos.posX + "," + pos.posZ + " in " + ServerUtils.getDimensionName(pos.dim).func_150260_c());
                chunk.setLoaded(false);
            }
        }
    }

    public void unforceChunk(ClaimedChunk chunk) {
        if (chunk.forced != null && !chunk.forced.booleanValue()) {
            return;
        }
        ChunkDimPos pos = chunk.getPos();
        ForgeChunkManager.Ticket ticket = this.chunkTickets.get(pos);
        if (ticket == null) {
            return;
        }
        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)pos.getChunkPos());
        this.chunkTickets.remove(pos);
        chunk.forced = false;
        if (ticket.getChunkList().isEmpty()) {
            this.ticketMap.remove(new TicketKey(pos.dim, chunk.getTeam().getId()));
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
        if (ServerUtilitiesConfig.debugging.log_chunkloading) {
            ServerUtilities.LOGGER.info(chunk.getTeam().getTitle().func_150260_c() + " unforced " + pos.posX + "," + pos.posZ + " in " + ServerUtils.getDimensionName(pos.dim).func_150260_c());
        }
    }

    public boolean canForceChunks(ForgeTeam team) {
        List<ForgePlayer> members = team.getMembers();
        for (ForgePlayer player : members) {
            if (!player.isOnline()) continue;
            return true;
        }
        for (ForgePlayer player : members) {
            if (!player.hasPermission("serverutilities.chunkloader.load_offline")) continue;
            return true;
        }
        return false;
    }
}

