/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.tp;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilities;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.data.ServerUtilitiesUniverseData;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.math.BlockDimPos;
import serverutils.lib.util.StringJoiner;
import serverutils.lib.util.text_components.Notification;
import serverutils.ranks.Ranks;
import serverutils.task.NotifyTask;

public class CmdWarp
extends CmdBase {
    public CmdWarp() {
        super("warp", CmdBase.Level.ALL);
    }

    @Override
    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CmdWarp.func_71531_a((String[])args, ServerUtilitiesUniverseData.WARPS.list());
        }
        return super.func_71516_a(sender, args);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        this.checkArgs(sender, args, 1);
        args[0] = args[0].toLowerCase();
        if (args[0].equals("list")) {
            Collection<String> list = ServerUtilitiesUniverseData.WARPS.list();
            sender.func_145747_a((IChatComponent)new ChatComponentText(list.isEmpty() ? "-" : StringJoiner.with(", ").join(list)));
            return;
        }
        EntityPlayerMP player = CmdWarp.func_71521_c((ICommandSender)sender);
        if (Ranks.INSTANCE.getPermissionResult(player, "command.serverutilities.warp.teleport." + args[0], true) == Event.Result.DENY) {
            throw new CommandException("commands.generic.permission", new Object[0]);
        }
        BlockDimPos p = ServerUtilitiesUniverseData.WARPS.get(args[0]);
        if (p == null) {
            throw ServerUtilities.error(sender, "serverutilities.lang.warps.not_set", args[0]);
        }
        ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(CommandUtils.getForgePlayer((ICommandSender)player));
        data.checkTeleportCooldown(sender, ServerUtilitiesPlayerData.Timer.WARP);
        IChatComponent component = ServerUtilities.lang(sender, "serverutilities.lang.warps.tp", args[0]);
        Notification notification = Notification.of("teleport", component);
        NotifyTask task = new NotifyTask(-1L, player, notification);
        ServerUtilitiesPlayerData.Timer.WARP.teleport(player, playerMP -> p.teleporter(), task);
    }
}

