/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.team;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesGameRules;
import serverutils.events.team.ForgeTeamChangedEvent;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.data.Universe;

public class CmdJoin
extends CmdBase {
    public CmdJoin() {
        super("join", CmdBase.Level.ALL);
    }

    @Override
    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            if (!ServerUtilitiesGameRules.canJoinTeam(sender.func_130014_f_())) {
                return Collections.emptyList();
            }
            ArrayList<String> list = new ArrayList<String>();
            try {
                ForgePlayer player = CommandUtils.getForgePlayer(sender);
                for (ForgeTeam team : Universe.get().getTeams()) {
                    if (!team.addMember(player, true)) continue;
                    list.add(team.getId());
                }
                if (list.size() > 1) {
                    list.sort(null);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return CmdJoin.func_71531_a((String[])args, list);
        }
        return super.func_71516_a(sender, args);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (!ServerUtilitiesGameRules.canJoinTeam(sender.func_130014_f_())) {
            throw ServerUtilities.error(sender, "feature_disabled_server", new Object[0]);
        }
        EntityPlayerMP player = CmdJoin.func_71521_c((ICommandSender)sender);
        ForgePlayer p = CommandUtils.getForgePlayer((ICommandSender)player);
        this.checkArgs(sender, args, 1);
        ForgeTeam team = CommandUtils.getTeam(sender, args[0]);
        if (team.addMember(p, true)) {
            if (p.team.isOwner(p)) {
                new ForgeTeamChangedEvent(team, p.team).post();
                p.team.removeMember(p);
            } else if (p.hasTeam()) {
                throw ServerUtilities.error(sender, "serverutilities.lang.team.error.must_leave", new Object[0]);
            }
        } else {
            throw ServerUtilities.error(sender, "serverutilities.lang.team.error.already_member", p.getDisplayName());
        }
        team.addMember(p, false);
    }
}

