/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.chunks;

import java.util.List;
import java.util.OptionalInt;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesNotifications;
import serverutils.data.ClaimedChunk;
import serverutils.data.ClaimedChunks;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.util.text_components.Notification;

public class CmdUnloadAll
extends CmdBase {
    public CmdUnloadAll() {
        super("unload_all", CmdBase.Level.ALL);
    }

    @Override
    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CmdUnloadAll.func_71531_a((String[])args, CommandUtils.getDimensionNames());
        }
        return super.func_71516_a(sender, args);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 1;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (!ClaimedChunks.isActive()) {
            throw ServerUtilities.error(sender, "feature_disabled_server", new Object[0]);
        }
        ForgePlayer p = CommandUtils.getSelfOrOther(sender, args, 1, "serverutilities.other_player.claims.unload");
        EntityPlayerMP player = CmdUnloadAll.func_71521_c((ICommandSender)sender);
        if (p.hasTeam()) {
            OptionalInt dimension = CommandUtils.parseDimension(sender, args, 0);
            for (ClaimedChunk chunk : ClaimedChunks.instance.getTeamChunks(p.team, dimension)) {
                chunk.setLoaded(false);
            }
        } else {
            throw ServerUtilities.error(sender, "serverutilities.lang.team.error.no_team", new Object[0]);
        }
        Notification.of(ServerUtilitiesNotifications.UNCLAIMED_ALL, ServerUtilities.lang(sender, "serverutilities.lang.chunks.unloaded_all", new Object[0])).send(player.field_71133_b, (EntityPlayer)player);
    }
}

