/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.IChatComponent;
import serverutils.lib.config.ConfigDouble;
import serverutils.lib.config.ConfigInt;
import serverutils.lib.config.ConfigString;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.gui.Button;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.GuiIcons;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.PanelScrollBar;
import serverutils.lib.gui.SimpleButton;
import serverutils.lib.gui.Theme;
import serverutils.lib.gui.Widget;
import serverutils.lib.gui.WidgetLayout;
import serverutils.lib.gui.WrappedIngredient;
import serverutils.lib.gui.misc.GuiEditConfig;
import serverutils.lib.gui.misc.GuiEditConfigValue;
import serverutils.lib.gui.misc.IConfigValueEditCallback;
import serverutils.lib.icon.Color4I;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.IconWithBorder;
import serverutils.lib.icon.ItemIcon;
import serverutils.lib.item.ItemEntryWithCount;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.misc.MouseButton;
import serverutils.net.MessageEditNBTResponse;
import serverutils.shadow.it.unimi.dsi.fastutil.bytes.ByteArrayList;
import serverutils.shadow.it.unimi.dsi.fastutil.ints.IntArrayList;

public class GuiEditNBT
extends GuiBase {
    public static final Icon NBT_BYTE = GuiEditNBT.getIcon("byte");
    public static final Icon NBT_SHORT = GuiEditNBT.getIcon("short");
    public static final Icon NBT_INT = GuiEditNBT.getIcon("int");
    public static final Icon NBT_LONG = GuiEditNBT.getIcon("long");
    public static final Icon NBT_FLOAT = GuiEditNBT.getIcon("float");
    public static final Icon NBT_DOUBLE = GuiEditNBT.getIcon("double");
    public static final Icon NBT_STRING = GuiEditNBT.getIcon("string");
    public static final Icon NBT_LIST = GuiEditNBT.getIcon("list");
    public static final Icon NBT_LIST_CLOSED = GuiEditNBT.getIcon("list_closed");
    public static final Icon NBT_LIST_OPEN = GuiEditNBT.getIcon("list_open");
    public static final Icon NBT_MAP = GuiEditNBT.getIcon("map");
    public static final Icon NBT_MAP_CLOSED = GuiEditNBT.getIcon("map_closed");
    public static final Icon NBT_MAP_OPEN = GuiEditNBT.getIcon("map_open");
    public static final Icon NBT_BYTE_ARRAY = GuiEditNBT.getIcon("byte_array");
    public static final Icon NBT_BYTE_ARRAY_CLOSED = GuiEditNBT.getIcon("byte_array_closed");
    public static final Icon NBT_BYTE_ARRAY_OPEN = GuiEditNBT.getIcon("byte_array_open");
    public static final Icon NBT_INT_ARRAY = GuiEditNBT.getIcon("int_array");
    public static final Icon NBT_INT_ARRAY_CLOSED = GuiEditNBT.getIcon("int_array_closed");
    public static final Icon NBT_INT_ARRAY_OPEN = GuiEditNBT.getIcon("int_array_open");
    private final NBTTagCompound info;
    private final ButtonNBTMap buttonNBTRoot;
    private ButtonNBT selected;
    public final Panel panelTopLeft;
    public final Panel panelTopRight;
    public final Panel panelNbt;
    public final PanelScrollBar scroll;
    private int shouldClose = 0;

    private static Icon getIcon(String name) {
        return Icon.getIcon("serverutilities:textures/gui/nbt/" + name + ".png");
    }

    private ButtonNBT getFrom(ButtonNBTCollection b, String key) {
        ButtonNBT buttonNBT;
        NBTBase nbt = b.getTag(key);
        switch (nbt.func_74732_a()) {
            case 10: {
                buttonNBT = new ButtonNBTMap(this.panelNbt, b, key, (NBTTagCompound)nbt);
                break;
            }
            case 9: {
                buttonNBT = new ButtonNBTList(this.panelNbt, b, key, (NBTTagList)nbt);
                break;
            }
            case 7: {
                buttonNBT = new ButtonNBTByteArray(this.panelNbt, b, key, (NBTTagByteArray)nbt);
                break;
            }
            case 11: {
                buttonNBT = new ButtonNBTIntArray(this.panelNbt, b, key, (NBTTagIntArray)nbt);
                break;
            }
            default: {
                buttonNBT = new ButtonNBTPrimitive(this.panelNbt, b, key, nbt);
            }
        }
        return buttonNBT;
    }

    public SimpleButton newTag(Panel panel, String t, Icon icon, Supplier<NBTBase> supplier) {
        return new SimpleButton(panel, t, icon, (gui, button) -> {
            ButtonNBT patt21021$temp = this.selected;
            if (patt21021$temp instanceof ButtonNBTMap) {
                ButtonNBTMap nbtMap = (ButtonNBTMap)patt21021$temp;
                new GuiEditConfigValue("value", new ConfigString("", Pattern.compile("^.+$")), (arg_0, arg_1) -> this.lambda$newTag$0(nbtMap, (Supplier)supplier, arg_0, arg_1)).openGui();
            } else {
                ButtonNBT patt21544$temp = this.selected;
                if (patt21544$temp instanceof ButtonNBTCollection) {
                    ButtonNBTCollection nbtCollection = (ButtonNBTCollection)patt21544$temp;
                    nbtCollection.setTag("-1", (NBTBase)supplier.get());
                    this.selected.updateChildren(false);
                    this.panelNbt.refreshWidgets();
                }
            }
        }){

            @Override
            public void drawBackground(Theme theme, int x, int y, int w, int h) {
                IconWithBorder.BUTTON_ROUND_GRAY.draw(x, y, w, h);
            }
        };
    }

    public GuiEditNBT(NBTTagCompound i, NBTTagCompound nbt) {
        this.info = i;
        this.panelTopLeft = new Panel(this){

            @Override
            public void addWidgets() {
                this.add(new SimpleButton(this, I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), GuiEditNBT.this.selected == GuiEditNBT.this.buttonNBTRoot ? GuiIcons.REMOVE_GRAY : GuiIcons.REMOVE, (widget, button) -> {
                    if (GuiEditNBT.this.selected != GuiEditNBT.this.buttonNBTRoot) {
                        ((GuiEditNBT)GuiEditNBT.this).selected.parent.setTag(((GuiEditNBT)GuiEditNBT.this).selected.key, null);
                        ((GuiEditNBT)GuiEditNBT.this).selected.parent.updateChildren(false);
                        GuiEditNBT.this.selected = ((GuiEditNBT)GuiEditNBT.this).selected.parent;
                        GuiEditNBT.this.panelNbt.refreshWidgets();
                        GuiEditNBT.this.panelTopLeft.refreshWidgets();
                    }
                }));
                boolean canRename = ((GuiEditNBT)GuiEditNBT.this).selected.parent instanceof ButtonNBTMap;
                this.add(new SimpleButton(this, I18n.func_135052_a((String)"gui.rename", (Object[])new Object[0]), canRename ? GuiIcons.INFO : GuiIcons.INFO_GRAY, (gui, button) -> {
                    if (canRename) {
                        new GuiEditConfigValue(((GuiEditNBT)GuiEditNBT.this).selected.key, new ConfigString(((GuiEditNBT)GuiEditNBT.this).selected.key), (value, set) -> {
                            String s;
                            if (set && !(s = value.getString()).isEmpty()) {
                                ButtonNBTCollection parent = ((GuiEditNBT)GuiEditNBT.this).selected.parent;
                                String s0 = ((GuiEditNBT)GuiEditNBT.this).selected.key;
                                NBTBase nbt = parent.getTag(s0);
                                parent.setTag(s0, null);
                                parent.setTag(s, nbt);
                                parent.updateChildren(false);
                                GuiEditNBT.this.selected = parent.children.get(s);
                                GuiEditNBT.this.panelNbt.refreshWidgets();
                            }
                            this.getGui().openGui();
                        }).openGui();
                    }
                }));
                ButtonNBT buttonNBT = GuiEditNBT.this.selected;
                if (buttonNBT instanceof ButtonNBTPrimitive) {
                    ButtonNBTPrimitive nbtPrimitive = (ButtonNBTPrimitive)buttonNBT;
                    this.add(new SimpleButton(this, I18n.func_135052_a((String)"selectServer.edit", (Object[])new Object[0]), GuiIcons.FEATHER, (widget, button) -> nbtPrimitive.edit()));
                }
                if (GuiEditNBT.this.selected.canCreateNew(10)) {
                    this.add(GuiEditNBT.this.newTag(this, "Compound", NBT_MAP, NBTTagCompound::new));
                }
                if (GuiEditNBT.this.selected.canCreateNew(9)) {
                    this.add(GuiEditNBT.this.newTag(this, "List", NBT_LIST, NBTTagList::new));
                }
                if (GuiEditNBT.this.selected.canCreateNew(8)) {
                    this.add(GuiEditNBT.this.newTag(this, "String", NBT_STRING, () -> new NBTTagString("")));
                }
                if (GuiEditNBT.this.selected.canCreateNew(1)) {
                    this.add(GuiEditNBT.this.newTag(this, "Byte", NBT_BYTE, () -> new NBTTagByte(0)));
                }
                if (GuiEditNBT.this.selected.canCreateNew(2)) {
                    this.add(GuiEditNBT.this.newTag(this, "Short", NBT_SHORT, () -> new NBTTagShort(0)));
                }
                if (GuiEditNBT.this.selected.canCreateNew(3)) {
                    this.add(GuiEditNBT.this.newTag(this, "Int", NBT_INT, () -> new NBTTagInt(0)));
                }
                if (GuiEditNBT.this.selected.canCreateNew(4)) {
                    this.add(GuiEditNBT.this.newTag(this, "Long", NBT_LONG, () -> new NBTTagLong(0L)));
                }
                if (GuiEditNBT.this.selected.canCreateNew(5)) {
                    this.add(GuiEditNBT.this.newTag(this, "Float", NBT_FLOAT, () -> new NBTTagFloat(0.0f)));
                }
                if (GuiEditNBT.this.selected.canCreateNew(6)) {
                    this.add(GuiEditNBT.this.newTag(this, "Double", NBT_DOUBLE, () -> new NBTTagDouble(0.0)));
                }
                if (GuiEditNBT.this.selected.canCreateNew(7)) {
                    this.add(GuiEditNBT.this.newTag(this, "Byte Array", NBT_BYTE_ARRAY, () -> new NBTTagByteArray(new byte[0])));
                }
                if (GuiEditNBT.this.selected.canCreateNew(11)) {
                    this.add(GuiEditNBT.this.newTag(this, "Int Array", NBT_INT_ARRAY, () -> new NBTTagIntArray(new int[0])));
                }
            }

            @Override
            public void alignWidgets() {
                this.setWidth(this.align(new WidgetLayout.Horizontal(2, 4, 2)));
            }
        };
        this.panelTopLeft.setPosAndSize(0, 2, 0, 16);
        this.panelTopRight = new Panel(this){

            @Override
            public void addWidgets() {
                this.add(new SimpleButton(this, I18n.func_135052_a((String)"gui.copy", (Object[])new Object[0]), ItemIcon.getItemIcon(Items.field_151121_aF), (widget, button) -> 3.setClipboardString(GuiEditNBT.this.selected.copy().toString())));
                this.add(new SimpleButton(this, I18n.func_135052_a((String)"gui.collapse_all", (Object[])new Object[0]), GuiIcons.REMOVE, (widget, button) -> {
                    for (Widget w : GuiEditNBT.this.panelNbt.widgets) {
                        if (!(w instanceof ButtonNBTCollection)) continue;
                        ButtonNBTCollection nbtCollection = (ButtonNBTCollection)w;
                        nbtCollection.setCollapsed(true);
                    }
                    GuiEditNBT.this.scroll.setValue(0);
                    GuiEditNBT.this.panelNbt.refreshWidgets();
                }));
                this.add(new SimpleButton(this, I18n.func_135052_a((String)"gui.expand_all", (Object[])new Object[0]), GuiIcons.ADD, (widget, button) -> {
                    for (Widget w : GuiEditNBT.this.panelNbt.widgets) {
                        if (!(w instanceof ButtonNBTCollection)) continue;
                        ButtonNBTCollection nbtCollection = (ButtonNBTCollection)w;
                        nbtCollection.setCollapsed(false);
                    }
                    GuiEditNBT.this.scroll.setValue(0);
                    GuiEditNBT.this.panelNbt.refreshWidgets();
                }));
                this.add(new SimpleButton(this, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), GuiIcons.CANCEL, (widget, button) -> {
                    GuiEditNBT.this.shouldClose = 2;
                    widget.getGui().closeGui();
                }));
                this.add(new SimpleButton(this, I18n.func_135052_a((String)"gui.accept", (Object[])new Object[0]), GuiIcons.ACCEPT, (widget, button) -> {
                    GuiEditNBT.this.shouldClose = 1;
                    widget.getGui().closeGui();
                }));
            }

            @Override
            public void alignWidgets() {
                this.setWidth(this.align(new WidgetLayout.Horizontal(2, 4, 2)));
            }
        };
        this.panelNbt = new Panel(this){

            @Override
            public void addWidgets() {
                this.add(GuiEditNBT.this.buttonNBTRoot);
                GuiEditNBT.this.buttonNBTRoot.addChildren();
            }

            @Override
            public void alignWidgets() {
                GuiEditNBT.this.scroll.setMaxValue(this.align(WidgetLayout.VERTICAL) + 2);
            }
        };
        this.buttonNBTRoot = new ButtonNBTMap(this.panelNbt, null, this.info.func_74764_b("title") ? IChatComponent.Serializer.func_150699_a((String)this.info.func_74779_i("title")).func_150254_d() : "ROOT", nbt);
        this.buttonNBTRoot.updateChildren(true);
        this.buttonNBTRoot.setCollapsedTree(true);
        this.buttonNBTRoot.setCollapsed(false);
        this.selected = this.buttonNBTRoot;
        this.scroll = new PanelScrollBar(this, this.panelNbt);
    }

    @Override
    public void addWidgets() {
        this.add(this.panelTopLeft);
        this.add(this.panelTopRight);
        this.add(this.panelNbt);
        this.add(this.scroll);
    }

    @Override
    public void alignWidgets() {
        this.panelTopRight.setPosAndSize(this.width - this.panelTopRight.width, 2, 0, 16);
        this.panelTopRight.alignWidgets();
        this.panelNbt.setPosAndSize(0, 21, this.width - this.scroll.width, this.height - 20);
        this.panelNbt.alignWidgets();
        this.scroll.setPosAndSize(this.width - this.scroll.width, 20, 16, this.panelNbt.height);
    }

    @Override
    public boolean onInit() {
        return this.setFullscreen();
    }

    @Override
    public void onClosed() {
        super.onClosed();
        if (this.shouldClose == 1) {
            new MessageEditNBTResponse(this.info, this.buttonNBTRoot.map).sendToServer();
        }
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        GuiEditConfig.COLOR_BACKGROUND.draw(0, 0, w, 20);
    }

    @Override
    public Theme getTheme() {
        return GuiEditConfig.THEME;
    }

    @Override
    public boolean doesGuiPauseGame() {
        return true;
    }

    private /* synthetic */ void lambda$newTag$0(ButtonNBTMap nbtMap, Supplier supplier, ConfigValue value, boolean set) {
        if (set && !value.getString().isEmpty()) {
            nbtMap.setTag(value.getString(), (NBTBase)supplier.get());
            this.selected.updateChildren(false);
            this.panelNbt.refreshWidgets();
        }
        this.openGui();
    }

    public class ButtonNBTMap
    extends ButtonNBTCollection {
        private NBTTagCompound map;
        private Icon hoverIcon;

        public ButtonNBTMap(@Nullable Panel panel, ButtonNBTCollection b, String key, NBTTagCompound m) {
            super(panel, b, key, NBT_MAP_OPEN, NBT_MAP_CLOSED);
            this.hoverIcon = Icon.EMPTY;
            this.map = m;
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            ArrayList<Object> list = new ArrayList<Object>(this.map.func_150296_c());
            list.sort(StringUtils.IGNORE_CASE_COMPARATOR);
            for (String string : list) {
                ButtonNBT nbt = GuiEditNBT.this.getFrom(this, string);
                this.children.put(string, nbt);
                nbt.updateChildren(first);
            }
            this.updateHoverIcon();
            if (first && !this.hoverIcon.isEmpty()) {
                this.setCollapsed(true);
            }
        }

        private void updateHoverIcon() {
            ItemEntryWithCount entry = new ItemEntryWithCount(this.map.func_74737_b());
            this.hoverIcon = !entry.isEmpty() ? ItemIcon.getItemIcon(entry.getStack(false)) : Icon.EMPTY;
            this.setWidth(12 + GuiEditNBT.this.getTheme().getStringWidth(this.getTitle()) + (this.hoverIcon.isEmpty() ? 0 : 10));
        }

        @Override
        public void addMouseOverText(List<String> list) {
            NBTTagList infoList;
            if (this == GuiEditNBT.this.buttonNBTRoot && (infoList = GuiEditNBT.this.info.func_150295_c("text", 8)).func_74745_c() > 0) {
                list.add(I18n.func_135052_a((String)"gui.info", (Object[])new Object[0]) + ":");
                for (int i = 0; i < infoList.func_74745_c(); ++i) {
                    IChatComponent component = IChatComponent.Serializer.func_150699_a((String)infoList.func_150307_f(i));
                    if (component == null) continue;
                    list.add(component.func_150254_d());
                }
            }
        }

        @Override
        public void draw(Theme theme, int x, int y, int w, int h) {
            super.draw(theme, x, y, w, h);
            if (!this.hoverIcon.isEmpty()) {
                this.hoverIcon.draw(x + 12 + theme.getStringWidth(this.getTitle()), y + 1, 8, 8);
            }
        }

        @Override
        @Nullable
        public Object getIngredientUnderMouse() {
            return new WrappedIngredient(this.hoverIcon.getIngredient()).tooltip();
        }

        @Override
        public NBTBase getTag(String k) {
            return this.map.func_74781_a(k);
        }

        @Override
        public void setTag(String k, @Nullable NBTBase base) {
            if (base != null) {
                this.map.func_74782_a(k, base);
            } else {
                this.map.func_82580_o(k);
            }
            this.updateHoverIcon();
            if (this.parent != null) {
                this.parent.setTag(this.key, (NBTBase)this.map);
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return true;
        }

        @Override
        public NBTTagCompound copy() {
            NBTTagCompound nbt = (NBTTagCompound)this.map.func_74737_b();
            if (this == GuiEditNBT.this.buttonNBTRoot) {
                NBTTagList infoList1 = new NBTTagList();
                NBTTagList infoList0 = GuiEditNBT.this.info.func_150295_c("text", 8);
                if (infoList0.func_74745_c() > 0) {
                    for (int i = 0; i < infoList0.func_74745_c(); ++i) {
                        IChatComponent component = IChatComponent.Serializer.func_150699_a((String)infoList0.func_150307_f(i));
                        if (component == null) continue;
                        infoList1.func_74742_a((NBTBase)new NBTTagString(component.func_150260_c()));
                    }
                    nbt.func_74782_a("_", (NBTBase)infoList1);
                }
            }
            return nbt;
        }
    }

    public abstract class ButtonNBTCollection
    extends ButtonNBT {
        public boolean collapsed;
        public final Map<String, ButtonNBT> children;
        public final Icon iconOpen;
        public final Icon iconClosed;

        public ButtonNBTCollection(@Nullable Panel panel, ButtonNBTCollection b, String key, Icon open, Icon closed) {
            super(panel, b, key);
            this.iconOpen = open;
            this.iconClosed = closed;
            this.setCollapsed(false);
            this.setWidth(this.width + 2 + GuiEditNBT.this.getTheme().getStringWidth(key));
            this.children = new LinkedHashMap<String, ButtonNBT>();
        }

        @Override
        public void addChildren() {
            if (!this.collapsed) {
                for (ButtonNBT button : this.children.values()) {
                    GuiEditNBT.this.panelNbt.add(button);
                    button.addChildren();
                }
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            if (this.getMouseX() <= this.getX() + this.height) {
                this.setCollapsed(!this.collapsed);
                GuiEditNBT.this.panelNbt.refreshWidgets();
            } else {
                GuiEditNBT.this.selected = this;
                GuiEditNBT.this.panelTopLeft.refreshWidgets();
            }
        }

        public void setCollapsed(boolean c) {
            this.collapsed = c;
            this.setIcon(this.collapsed ? this.iconClosed : this.iconOpen);
        }

        public void setCollapsedTree(boolean c) {
            this.setCollapsed(c);
            for (ButtonNBT button : this.children.values()) {
                if (!(button instanceof ButtonNBTCollection)) continue;
                ButtonNBTCollection nbtCollection = (ButtonNBTCollection)button;
                nbtCollection.setCollapsedTree(c);
            }
        }

        public abstract NBTBase getTag(String var1);

        public abstract void setTag(String var1, @Nullable NBTBase var2);
    }

    public abstract class ButtonNBT
    extends Button {
        public final ButtonNBTCollection parent;
        public String key;

        public ButtonNBT(@Nullable Panel panel, ButtonNBTCollection b, String k) {
            super(panel);
            this.setPosAndSize(b == null ? 0 : b.posX + 10, 0, 10, 10);
            this.parent = b;
            this.key = k;
            this.setTitle(this.key);
        }

        public abstract NBTTagCompound copy();

        public void updateChildren(boolean first) {
        }

        public void addChildren() {
        }

        public boolean canCreateNew(int id) {
            return false;
        }

        @Override
        public void addMouseOverText(List<String> list) {
        }

        @Override
        public void draw(Theme theme, int x, int y, int w, int h) {
            if (GuiEditNBT.this.selected == this) {
                Color4I.WHITE.withAlpha(33).draw(x, y, w, h);
            }
            IconWithBorder.BUTTON_ROUND_GRAY.draw(x + 1, y + 1, 8, 8);
            this.drawIcon(theme, x + 1, y + 1, 8, 8);
            theme.drawString(this.getTitle(), x + 11, y + 1);
        }
    }

    public class ButtonNBTList
    extends ButtonNBTCollection {
        private NBTTagList list;

        public ButtonNBTList(Panel panel, ButtonNBTCollection p, String key, NBTTagList l) {
            super(panel, p, key, NBT_LIST_OPEN, NBT_LIST_CLOSED);
            this.list = l;
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            for (int i = 0; i < this.list.func_74745_c(); ++i) {
                String s = Integer.toString(i);
                ButtonNBT nbt = GuiEditNBT.this.getFrom(this, s);
                this.children.put(s, nbt);
                nbt.updateChildren(first);
            }
        }

        @Override
        public NBTBase getTag(String k) {
            return (NBTBase)this.list.field_74747_a.get(Integer.parseInt(k));
        }

        @Override
        public void setTag(String k, @Nullable NBTBase base) {
            int id = Integer.parseInt(k);
            if (id == -1) {
                if (base != null) {
                    this.list.func_74742_a(base);
                }
            } else if (base != null) {
                this.list.func_150304_a(id, base);
            } else {
                this.list.func_74744_a(id);
            }
            if (this.parent != null) {
                this.parent.setTag(this.key, (NBTBase)this.list);
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return this.list.func_74745_c() == 0 || this.list.func_74732_a() == id;
        }

        @Override
        public NBTTagCompound copy() {
            NBTTagCompound n = new NBTTagCompound();
            n.func_74782_a(this.key, (NBTBase)this.list);
            return n;
        }
    }

    public class ButtonNBTByteArray
    extends ButtonNBTCollection {
        private ByteArrayList list;

        public ButtonNBTByteArray(Panel panel, ButtonNBTCollection p, String key, NBTTagByteArray l) {
            super(panel, p, key, NBT_BYTE_ARRAY_OPEN, NBT_BYTE_ARRAY_CLOSED);
            this.list = new ByteArrayList(l.func_150292_c());
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            for (int i = 0; i < this.list.size(); ++i) {
                String s = Integer.toString(i);
                ButtonNBT nbt = GuiEditNBT.this.getFrom(this, s);
                this.children.put(s, nbt);
                nbt.updateChildren(first);
            }
        }

        @Override
        public NBTBase getTag(String k) {
            return new NBTTagByte(this.list.getByte(Integer.parseInt(k)));
        }

        @Override
        public void setTag(String k, @Nullable NBTBase base) {
            int id = Integer.parseInt(k);
            if (id == -1) {
                if (base != null) {
                    this.list.add(((NBTBase.NBTPrimitive)base).func_150290_f());
                }
            } else if (base != null) {
                this.list.set(id, ((NBTBase.NBTPrimitive)base).func_150290_f());
            } else {
                this.list.removeByte(id);
            }
            if (this.parent != null) {
                this.parent.setTag(this.key, (NBTBase)new NBTTagByteArray(this.list.toByteArray()));
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return id == 1;
        }

        @Override
        public NBTTagCompound copy() {
            NBTTagCompound n = new NBTTagCompound();
            n.func_74782_a(this.key, (NBTBase)new NBTTagByteArray(this.list.toByteArray()));
            return n;
        }
    }

    public class ButtonNBTIntArray
    extends ButtonNBTCollection {
        private IntArrayList list;

        public ButtonNBTIntArray(Panel panel, ButtonNBTCollection p, String key, NBTTagIntArray l) {
            super(panel, p, key, NBT_INT_ARRAY_OPEN, NBT_INT_ARRAY_CLOSED);
            this.list = new IntArrayList(l.func_150302_c());
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            for (int i = 0; i < this.list.size(); ++i) {
                String s = Integer.toString(i);
                ButtonNBT nbt = GuiEditNBT.this.getFrom(this, s);
                this.children.put(s, nbt);
                nbt.updateChildren(first);
            }
        }

        @Override
        public NBTBase getTag(String k) {
            return new NBTTagInt(this.list.getInt(Integer.parseInt(k)));
        }

        @Override
        public void setTag(String k, @Nullable NBTBase base) {
            int id = Integer.parseInt(k);
            if (id == -1) {
                if (base != null) {
                    this.list.add(((NBTBase.NBTPrimitive)base).func_150287_d());
                }
            } else if (base != null) {
                this.list.set(id, ((NBTBase.NBTPrimitive)base).func_150287_d());
            } else {
                this.list.rem(id);
            }
            if (this.parent != null) {
                this.parent.setTag(this.key, (NBTBase)new NBTTagIntArray(this.list.toIntArray()));
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return id == 3;
        }

        @Override
        public NBTTagCompound copy() {
            NBTTagCompound n = new NBTTagCompound();
            n.func_74782_a(this.key, (NBTBase)new NBTTagIntArray(this.list.toIntArray()));
            return n;
        }
    }

    public class ButtonNBTPrimitive
    extends ButtonNBT
    implements IConfigValueEditCallback {
        private NBTBase nbt;

        public ButtonNBTPrimitive(Panel panel, ButtonNBTCollection b, String k, NBTBase n) {
            super(panel, b, k);
            this.nbt = n;
            switch (this.nbt.func_74732_a()) {
                case 1: {
                    this.setIcon(NBT_BYTE);
                    break;
                }
                case 2: {
                    this.setIcon(NBT_SHORT);
                    break;
                }
                case 3: {
                    this.setIcon(NBT_INT);
                    break;
                }
                case 4: {
                    this.setIcon(NBT_LONG);
                    break;
                }
                case 5: {
                    this.setIcon(NBT_FLOAT);
                    break;
                }
                case 6: 
                case 99: {
                    this.setIcon(NBT_DOUBLE);
                    break;
                }
                case 8: {
                    this.setIcon(NBT_STRING);
                }
            }
            this.parent.setTag(this.key, this.nbt);
            this.updateTitle();
        }

        public void updateTitle() {
            Object object;
            switch (this.nbt.func_74732_a()) {
                case 1: 
                case 2: 
                case 3: {
                    object = ((NBTBase.NBTPrimitive)this.nbt).func_150287_d();
                    break;
                }
                case 4: {
                    object = ((NBTBase.NBTPrimitive)this.nbt).func_150291_c();
                    break;
                }
                case 5: 
                case 6: 
                case 99: {
                    object = ((NBTBase.NBTPrimitive)this.nbt).func_150286_g();
                    break;
                }
                case 8: {
                    object = ((NBTTagString)this.nbt).func_150285_a_();
                    break;
                }
                default: {
                    object = "";
                }
            }
            String title = object;
            this.setTitle(this.key + ": " + title);
            this.setWidth(12 + GuiEditNBT.this.getTheme().getStringWidth(this.key + ": " + title));
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiEditNBT.this.selected = this;
            GuiEditNBT.this.panelTopLeft.refreshWidgets();
            if (button.isRight()) {
                this.edit();
            }
        }

        public void edit() {
            switch (this.nbt.func_74732_a()) {
                case 1: 
                case 2: 
                case 3: {
                    new GuiEditConfigValue(this.key, new ConfigInt(((NBTBase.NBTPrimitive)this.nbt).func_150287_d()), this).openGui();
                    break;
                }
                case 4: {
                    new GuiEditConfigValue(this.key, new ConfigString(Long.toString(((NBTBase.NBTPrimitive)this.nbt).func_150291_c())), this).openGui();
                    break;
                }
                case 5: 
                case 6: 
                case 99: {
                    new GuiEditConfigValue(this.key, new ConfigDouble(((NBTBase.NBTPrimitive)this.nbt).func_150286_g()), this).openGui();
                    break;
                }
                case 8: {
                    new GuiEditConfigValue(this.key, new ConfigString(((NBTTagString)this.nbt).func_150285_a_()), this).openGui();
                }
            }
        }

        @Override
        public void onCallback(ConfigValue value, boolean set) {
            if (set) {
                switch (this.nbt.func_74732_a()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.nbt = new NBTTagInt(value.getInt());
                        break;
                    }
                    case 4: {
                        this.nbt = new NBTTagLong(Long.parseLong(value.getString()));
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 99: {
                        this.nbt = new NBTTagDouble(value.getDouble());
                        break;
                    }
                    case 8: {
                        this.nbt = new NBTTagString(value.getString());
                    }
                }
                this.parent.setTag(this.key, this.nbt);
                this.updateTitle();
            }
            GuiEditNBT.this.openGui();
        }

        @Override
        public NBTTagCompound copy() {
            NBTTagCompound n = new NBTTagCompound();
            n.func_74782_a(this.key, this.nbt);
            return n;
        }
    }
}

