/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui;

import cpw.mods.fml.client.config.GuiConfig;
import cpw.mods.fml.client.config.IConfigElement;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraftforge.common.config.ConfigElement;
import serverutils.client.ServerUtilitiesClientConfig;
import serverutils.client.gui.GuiSidebarButtonConfig;
import serverutils.client.gui.SidebarButtonManager;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.GuiIcons;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.SimpleTextButton;
import serverutils.lib.gui.WidgetType;
import serverutils.lib.gui.misc.GuiButtonListBase;
import serverutils.lib.gui.misc.GuiLoading;
import serverutils.lib.icon.Icon;
import serverutils.lib.util.SidedUtils;
import serverutils.lib.util.misc.MouseButton;

public class GuiClientConfig
extends GuiButtonListBase {
    private final List<IConfigElement> configElement = new ConfigElement(ServerUtilitiesClientConfig.config.getCategory("general")).getChildElements();

    public GuiClientConfig() {
        this.setTitle(I18n.func_135052_a((String)"sidebar_button.serverutilities.settings", (Object[])new Object[0]));
    }

    @Override
    public void addButtons(Panel panel) {
        panel.add(new SimpleTextButton(panel, I18n.func_135052_a((String)"player_config", (Object[])new Object[0]), GuiIcons.SETTINGS_RED){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                new GuiLoading().openGui();
                ClientUtils.execClientCommand("/my_settings");
            }

            @Override
            public WidgetType getWidgetType() {
                return SidedUtils.isModLoadedOnServer("serverutilities") ? super.getWidgetType() : WidgetType.DISABLED;
            }
        });
        panel.add(new SimpleTextButton(panel, I18n.func_135052_a((String)"sidebar_button", (Object[])new Object[0]), Icon.getIcon("serverutilities:textures/gui/teams.png")){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                new GuiSidebarButtonConfig().openGui();
            }
        });
        panel.add(new SimpleTextButton(panel, new ChatComponentTranslation("serverutilities_client", new Object[0]).func_150260_c(), Icon.getIcon("serverutilities:textures/logo_small.png")){

            @Override
            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiCustomConfig(this.getTitle()));
            }
        });
    }

    @Override
    public void onClosed() {
        super.onClosed();
        SidebarButtonManager.INSTANCE.saveConfig();
    }

    private class GuiCustomConfig
    extends GuiConfig {
        public GuiCustomConfig(String title) {
            super(Minecraft.func_71410_x().field_71462_r, GuiClientConfig.this.configElement, "serverutilities", false, false, title, GuiCustomConfig.getAbridgedConfigPath((String)"serverutilities/client/serverutilities.cfg"));
        }
    }
}

