/*
 * Decompiled with CFR 0.152.
 */
package serverutils;

import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.data.ClaimedChunk;
import serverutils.data.ClaimedChunks;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.text_components.Notification;

public class ServerUtilitiesNotifications {
    public static final ResourceLocation CHUNK_MODIFIED = new ResourceLocation("serverutilities", "chunk_modified");
    public static final ResourceLocation CHUNK_CHANGED = new ResourceLocation("serverutilities", "chunk_changed");
    public static final ResourceLocation CHUNK_CANT_CLAIM = new ResourceLocation("serverutilities", "cant_claim_chunk");
    public static final ResourceLocation UNCLAIMED_ALL = new ResourceLocation("serverutilities", "unclaimed_all");
    public static final String TELEPORT = "teleport";
    public static final ResourceLocation TELEPORT_WARMUP = new ResourceLocation("serverutilities", "teleport_warmup");
    public static final ResourceLocation RELOAD_SERVER = new ResourceLocation("serverutilities", "reload_server");
    public static final ResourceLocation BACKUP_START = new ResourceLocation("serverutilities", "backup_start");
    public static final ResourceLocation BACKUP_END1 = new ResourceLocation("serverutilities", "backup_end1");
    public static final ResourceLocation BACKUP_END2 = new ResourceLocation("serverutilities", "backup_end2");
    public static final ResourceLocation CONFIG_CHANGED = new ResourceLocation("serverutilities", "config_changed");
    public static final String RESTART_TIMER_ID = "restart_timer";
    public static final Notification NO_TEAM = Notification.of(new ResourceLocation("serverutilities", "no_team"), new IChatComponent[]{new ChatComponentTranslation("serverutilities.lang.team.error.no_team", new Object[0])}).setError();

    public static void sendCantModifyChunk(MinecraftServer server, EntityPlayerMP player) {
        Notification.of(new ResourceLocation("serverutilities", "cant_modify_chunk"), ServerUtilities.lang((ICommandSender)player, "serverutilities.lang.chunks.cant_modify_chunk", new Object[0])).setError().send(server, (EntityPlayer)player);
    }

    public static void updateChunkMessage(EntityPlayerMP player, ChunkDimPos pos) {
        short teamID;
        if (!ClaimedChunks.isActive()) {
            return;
        }
        ClaimedChunk chunk = ClaimedChunks.instance.getChunk(pos);
        ForgeTeam team = chunk == null ? null : chunk.getTeam();
        short s = teamID = team == null ? (short)0 : team.getUID();
        if (player.getEntityData().func_74765_d("serveru_lchunk") != teamID) {
            if (teamID == 0) {
                player.getEntityData().func_82580_o("serveru_lchunk");
            } else {
                player.getEntityData().func_74777_a("serveru_lchunk", teamID);
            }
            if (team != null) {
                Notification notification = Notification.of(CHUNK_CHANGED, team.getTitle());
                if (!team.getDesc().isEmpty()) {
                    notification.addLine(StringUtils.italic((IChatComponent)new ChatComponentText(team.getDesc()), true));
                }
                notification.send(player.field_71133_b, (EntityPlayer)player);
            } else {
                Notification.of(CHUNK_CHANGED, StringUtils.color(ServerUtilities.lang((ICommandSender)player, "serverutilities.lang.chunks.wilderness", new Object[0]), EnumChatFormatting.DARK_GREEN)).send(player.field_71133_b, (EntityPlayer)player);
            }
        }
    }

    public static void backupNotification(ResourceLocation id, String key, Object ... args) {
        if (!ServerUtilitiesConfig.backups.silent_backup) {
            Notification.of(id, StringUtils.color(ServerUtilities.lang(null, key, args), EnumChatFormatting.LIGHT_PURPLE)).send(ServerUtils.getServer(), null);
        }
    }
}

