/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import baubles.api.BaubleType;
import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import baubles.common.network.PacketSyncBauble;
import com.gtnewhorizon.gtnhlib.GTNHLib;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.item.IExtendedWireframeCoordinateListProvider;
import vazkii.botania.api.item.IInWorldRenderable;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.BoundTileRenderer;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.LokiCursor;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.ItemRelicBauble;
import vazkii.botania.common.network.PacketHandler;
import vazkii.botania.common.network.PacketLokiHudNotificationAck;

public class ItemLokiRing
extends ItemRelicBauble
implements IExtendedWireframeCoordinateListProvider,
IManaUsingItem,
IInWorldRenderable {
    private static final String TAG_CURSOR_LIST = "cursorList";
    private static final String TAG_CURSOR_PREFIX = "cursor";
    private static final String TAG_CURSOR_COUNT = "cursorCount";
    private static final String TAG_X_ORIGIN = "xOrigin";
    private static final String TAG_Y_ORIGIN = "yOrigin";
    private static final String TAG_Z_ORIGIN = "zOrigin";
    private static final String TAG_MODE = "mode";
    private static final String TAG_BREAKING_MODE = "breaking";
    private static final String TAG_MIRROR_MODE = "mirror";
    private boolean recursion = false;

    public ItemLokiRing() {
        super("lokiRing");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        int x = event.x;
        int y = event.y;
        int z = event.z;
        int side = event.blockMetadata;
        ItemStack stack = player.func_71045_bC();
        if (stack == null) {
            return;
        }
        Item item = player.func_71045_bC().func_77973_b();
        ItemLokiRing.breakOnAllCursors(player, item, stack, x, y, z, side);
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        block33: {
            if (this.recursion) {
                return;
            }
            EntityPlayer player = event.entityPlayer;
            ItemStack lokiRing = ItemLokiRing.getLokiRing(player);
            if (lokiRing == null || player.field_70170_p.field_72995_K) {
                return;
            }
            ItemStack heldItemStack = player.func_71045_bC();
            ChunkCoordinates originCoords = ItemLokiRing.getOriginPos(lokiRing);
            MovingObjectPosition lookPos = ToolCommons.raytraceFromEntity(player.field_70170_p, (Entity)player, true, 10.0);
            List<LokiCursor> cursors = ItemLokiRing.getCursorList(lokiRing);
            int cursorCount = cursors.size();
            int cost = (int)(50.0 * Math.sin(0.04 * (double)cursorCount) + (double)cursorCount + 120.0 + 20.0 * Math.cos(0.2 * (double)cursorCount));
            if (heldItemStack == null && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && player.func_70093_af() && ItemLokiRing.isRingEnabled(lokiRing)) {
                if (originCoords.field_71572_b == -1 && lookPos != null) {
                    ItemLokiRing.setOriginPos(lokiRing, lookPos.field_72311_b, lookPos.field_72312_c, lookPos.field_72309_d);
                    if (player instanceof EntityPlayerMP) {
                        ItemLokiRing.syncLokiRing(player);
                    }
                } else if (lookPos != null) {
                    if (originCoords.field_71574_a == lookPos.field_72311_b && originCoords.field_71572_b == lookPos.field_72312_c && originCoords.field_71573_c == lookPos.field_72309_d) {
                        ItemLokiRing.clearMasterCursor(lokiRing);
                        if (player instanceof EntityPlayerMP) {
                            ItemLokiRing.syncLokiRing(player);
                        }
                    } else {
                        int relX = lookPos.field_72311_b - originCoords.field_71574_a;
                        int relY = lookPos.field_72312_c - originCoords.field_71572_b;
                        int relZ = lookPos.field_72309_d - originCoords.field_71573_c;
                        for (LokiCursor cursor : cursors) {
                            if (cursor.getX() != relX || cursor.getY() != relY || cursor.getZ() != relZ) continue;
                            cursors.remove(cursor);
                            ItemLokiRing.setCursorList(lokiRing, cursors);
                            if (player instanceof EntityPlayerMP) {
                                ItemLokiRing.syncLokiRing(player);
                            }
                            break block33;
                        }
                        ItemLokiRing.addCursor(lokiRing, relX, relY, relZ, ItemLokiRing.getRingMirrorMode(lokiRing));
                        if (player instanceof EntityPlayerMP) {
                            ItemLokiRing.syncLokiRing(player);
                        }
                    }
                }
            } else if (heldItemStack != null && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && lookPos != null && ItemLokiRing.isRingEnabled(lokiRing)) {
                if (!ManaItemHandler.requestManaExact(lokiRing, player, cost, true)) {
                    if (player instanceof EntityPlayerMP) {
                        PacketHandler.INSTANCE.sendTo((IMessage)new PacketLokiHudNotificationAck(HUD_MESSAGE.INSUFFICIENT_MANA), (EntityPlayerMP)player);
                    } else {
                        ItemLokiRing.renderHUDNotification(HUD_MESSAGE.INSUFFICIENT_MANA);
                    }
                    return;
                }
                this.recursion = true;
                double oldPosX = player.field_70165_t;
                double oldPosY = player.field_70163_u;
                double oldPosZ = player.field_70161_v;
                float oldPitch = player.field_70125_A;
                float oldYaw = player.field_70177_z;
                int masterOffsetX = originCoords.field_71572_b == -1 ? 0 : lookPos.field_72311_b - originCoords.field_71574_a;
                int masterOffsetY = originCoords.field_71572_b == -1 ? 0 : lookPos.field_72312_c - originCoords.field_71572_b;
                int masterOffsetZ = originCoords.field_71572_b == -1 ? 0 : lookPos.field_72309_d - originCoords.field_71573_c;
                double playerOffsetX = player.field_70165_t - (double)originCoords.field_71574_a;
                double playerOffsetY = player.field_70163_u - (double)originCoords.field_71572_b;
                double playerOffsetZ = player.field_70161_v - (double)originCoords.field_71573_c;
                for (LokiCursor cursor : cursors) {
                    int x = lookPos.field_72311_b + cursor.getX();
                    int y = lookPos.field_72312_c + cursor.getY();
                    int z = lookPos.field_72309_d + cursor.getZ();
                    if (cursor.isMirrorX()) {
                        x -= 2 * masterOffsetX;
                    }
                    if (cursor.isMirrorY()) {
                        y -= 2 * masterOffsetY;
                    }
                    if (cursor.isMirrorZ()) {
                        z -= 2 * masterOffsetZ;
                    }
                    if (player.field_70170_p.func_147437_c(x, y, z)) continue;
                    player.field_70165_t = (double)cursor.getX() + oldPosX;
                    player.field_70163_u = (double)cursor.getY() + oldPosY;
                    player.field_70161_v = (double)cursor.getZ() + oldPosZ;
                    player.field_70177_z = oldYaw;
                    if (cursor.isMirrorX()) {
                        player.field_70165_t -= 2.0 * playerOffsetX;
                        player.field_70177_z *= -1.0f;
                    }
                    if (cursor.isMirrorY()) {
                        player.field_70163_u -= 2.0 * playerOffsetY;
                        player.field_70125_A = oldPitch * -1.0f;
                    }
                    if (cursor.isMirrorZ()) {
                        player.field_70161_v -= 2.0 * playerOffsetZ;
                        player.field_70177_z = 180.0f - Math.abs(player.field_70177_z);
                        if (oldYaw < 0.0f) {
                            player.field_70177_z *= -1.0f;
                        }
                    }
                    float hitX = (float)(lookPos.field_72307_f.field_72450_a - (double)lookPos.field_72311_b);
                    float hitY = (float)(lookPos.field_72307_f.field_72448_b - (double)lookPos.field_72312_c);
                    float hitZ = (float)(lookPos.field_72307_f.field_72449_c - (double)lookPos.field_72309_d);
                    if (cursor.isMirrorX()) {
                        hitX = 1.0f - hitX;
                    }
                    if (cursor.isMirrorY()) {
                        hitY = 1.0f - hitY;
                    }
                    if (cursor.isMirrorZ()) {
                        hitZ = 1.0f - hitZ;
                    }
                    int hitSide = lookPos.field_72310_e;
                    if (cursor.isMirrorX() && (hitSide == ForgeDirection.EAST.ordinal() || hitSide == ForgeDirection.WEST.ordinal())) {
                        hitSide ^= 1;
                    }
                    if (cursor.isMirrorY() && (hitSide == ForgeDirection.DOWN.ordinal() || hitSide == ForgeDirection.UP.ordinal())) {
                        hitSide ^= 1;
                    }
                    if (cursor.isMirrorZ() && (hitSide == ForgeDirection.NORTH.ordinal() || hitSide == ForgeDirection.SOUTH.ordinal())) {
                        hitSide ^= 1;
                    }
                    Item item = heldItemStack.func_77973_b();
                    Block markedBlock = player.field_70170_p.func_147439_a(x, y, z);
                    boolean wasActivated = markedBlock.func_149727_a(player.field_70170_p, x, y, z, player, hitSide, hitX, hitY, hitZ);
                    if (heldItemStack.field_77994_a == 0) {
                        event.setCanceled(true);
                        break;
                    }
                    if (wasActivated) continue;
                    item.func_77648_a(player.field_71075_bZ.field_75098_d ? heldItemStack.func_77946_l() : heldItemStack, player, player.field_70170_p, x, y, z, hitSide, (float)lookPos.field_72307_f.field_72450_a - (float)x, (float)lookPos.field_72307_f.field_72448_b - (float)y, (float)lookPos.field_72307_f.field_72449_c - (float)z);
                    if (heldItemStack.field_77994_a != 0) continue;
                    event.setCanceled(true);
                    break;
                }
                this.recursion = false;
                player.field_70165_t = oldPosX;
                player.field_70163_u = oldPosY;
                player.field_70161_v = oldPosZ;
                player.field_70125_A = oldPitch;
                player.field_70177_z = oldYaw;
            }
        }
    }

    public static void setMode(ItemStack stack, boolean state) {
        stack.field_77990_d.func_74757_a(TAG_MODE, state);
    }

    public static void setBreakingMode(ItemStack stack, boolean state) {
        stack.field_77990_d.func_74757_a(TAG_BREAKING_MODE, state);
    }

    public static void setMirrorMode(ItemStack stack, byte state) {
        stack.field_77990_d.func_74774_a(TAG_MIRROR_MODE, state);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderHUDNotification(HUD_MESSAGE type) {
        String text;
        Minecraft mc = Minecraft.func_71410_x();
        switch (type) {
            case MODE: {
                text = ItemLokiRing.getLokiModeText(ItemLokiRing.getLokiRing((EntityPlayer)mc.field_71439_g));
                break;
            }
            case BREAKING: {
                text = ItemLokiRing.getLokiBreakingModeText(ItemLokiRing.getLokiRing((EntityPlayer)mc.field_71439_g));
                break;
            }
            case CLEAR: {
                text = ItemLokiRing.getLokiCearText(ItemLokiRing.getLokiRing((EntityPlayer)mc.field_71439_g));
                break;
            }
            case MIRROR: {
                text = ItemLokiRing.getLokiMirrorText(ItemLokiRing.getLokiRing((EntityPlayer)mc.field_71439_g));
                break;
            }
            case INSUFFICIENT_MANA: {
                text = EnumChatFormatting.RED + StatCollector.func_74838_a((String)"botaniamisc.insufficient_mana");
                break;
            }
            default: {
                return;
            }
        }
        GTNHLib.proxy.printMessageAboveHotbar(text, 60, true, true);
    }

    public static String getOnOffString(boolean state) {
        return state ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"botaniamisc.lokiOn") : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"botaniamisc.lokiOff");
    }

    public static String getAxisString(byte state) {
        EnumChatFormatting x = LokiCursor.isMirrorX(state) ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        EnumChatFormatting y = LokiCursor.isMirrorY(state) ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        EnumChatFormatting z = LokiCursor.isMirrorZ(state) ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        return x + "X " + y + "Y " + z + "Z";
    }

    public static String getLokiModeText(ItemStack stack) {
        return EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"item.botania:lokiRing.name") + " " + ItemLokiRing.getOnOffString(ItemLokiRing.isRingEnabled(stack));
    }

    public static String getLokiMirrorText(ItemStack stack) {
        return EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"botaniamisc.lokiMirror") + " " + ItemLokiRing.getAxisString(ItemLokiRing.getRingMirrorMode(stack));
    }

    public static String getLokiCearText(ItemStack stack) {
        return EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"botaniamisc.lokiClear");
    }

    public static String getLokiBreakingModeText(ItemStack stack) {
        return EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"item.botania:lokiRing.name") + " " + StatCollector.func_74838_a((String)"botaniamisc.breaking") + " " + ItemLokiRing.getOnOffString(ItemLokiRing.isRingBreakingEnabled(stack));
    }

    public static boolean isRingEnabled(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.field_77990_d.func_74767_n(TAG_MODE);
        }
        return false;
    }

    public static boolean isRingBreakingEnabled(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.field_77990_d.func_74767_n(TAG_BREAKING_MODE);
        }
        return false;
    }

    public static byte getRingMirrorMode(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.field_77990_d.func_74771_c(TAG_MIRROR_MODE);
        }
        return 0;
    }

    public static void breakOnAllCursors(EntityPlayer player, Item item, ItemStack stack, int x, int y, int z, int side) {
        ItemStack lokiRing = ItemLokiRing.getLokiRing(player);
        if (lokiRing == null || player.field_70170_p.field_72995_K || !ItemLokiRing.isRingEnabled(lokiRing) || !ItemLokiRing.isRingBreakingEnabled(lokiRing)) {
            return;
        }
        List<LokiCursor> cursors = ItemLokiRing.getCursorList(lokiRing);
        int cost = 30 * cursors.size();
        if (!ManaItemHandler.requestManaExact(lokiRing, player, cost, true)) {
            if (player instanceof EntityPlayerMP) {
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketLokiHudNotificationAck(HUD_MESSAGE.INSUFFICIENT_MANA), (EntityPlayerMP)player);
            } else {
                ItemLokiRing.renderHUDNotification(HUD_MESSAGE.INSUFFICIENT_MANA);
            }
        }
        ISequentialBreaker breaker = null;
        if (item instanceof ISequentialBreaker) {
            breaker = (ISequentialBreaker)item;
        }
        World world = player.field_70170_p;
        boolean silk = EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)stack) > 0;
        int fortune = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack);
        ChunkCoordinates originCoords = ItemLokiRing.getOriginPos(lokiRing);
        int masterOffsetX = originCoords.field_71572_b == -1 ? 0 : x - originCoords.field_71574_a;
        int masterOffsetY = originCoords.field_71572_b == -1 ? 0 : y - originCoords.field_71572_b;
        int masterOffsetZ = originCoords.field_71572_b == -1 ? 0 : z - originCoords.field_71573_c;
        for (int i = 0; i < cursors.size(); ++i) {
            LokiCursor cursor = cursors.get(i);
            int xp = x + cursor.getX();
            int yp = y + cursor.getY();
            int zp = z + cursor.getZ();
            if (cursor.isMirrorX()) {
                xp -= 2 * masterOffsetX;
            }
            if (cursor.isMirrorY()) {
                yp -= 2 * masterOffsetY;
            }
            if (cursor.isMirrorZ()) {
                zp -= 2 * masterOffsetZ;
            }
            if (cursor.isMirrorX() && (side == ForgeDirection.EAST.ordinal() || side == ForgeDirection.WEST.ordinal())) {
                side ^= 1;
            }
            if (cursor.isMirrorY() && (side == ForgeDirection.DOWN.ordinal() || side == ForgeDirection.UP.ordinal())) {
                side ^= 1;
            }
            if (cursor.isMirrorZ() && (side == ForgeDirection.NORTH.ordinal() || side == ForgeDirection.SOUTH.ordinal())) {
                side ^= 1;
            }
            Block block = world.func_147439_a(xp, yp, zp);
            if (breaker != null) {
                breaker.breakOtherBlock(player, stack, xp, yp, zp, x, y, z, side);
            }
            ToolCommons.removeBlockWithDrops(player, stack, player.field_70170_p, xp, yp, zp, x, y, z, block, new Material[]{block.func_149688_o()}, silk, fortune, block.func_149712_f(world, xp, yp, zp), true);
        }
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.RING;
    }

    @Override
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        ItemLokiRing.clearCursors(stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        this.addStringToTooltip(StatCollector.func_74838_a((String)"botaniamisc.lokiDescription"), list);
        this.addStringToTooltip(StatCollector.func_74838_a((String)"botaniamisc.lokiDescription2"), list);
        this.addStringToTooltip("", list);
        this.addStringToTooltip(EnumChatFormatting.WHITE + StatCollector.func_74838_a((String)"botaniamisc.lokiCurrent"), list);
        this.addStringToTooltip(StatCollector.func_74838_a((String)"botaniamisc.lokiState") + ": " + ItemLokiRing.getOnOffString(ItemLokiRing.isRingEnabled(stack)), list);
        this.addStringToTooltip(StatCollector.func_74838_a((String)"botaniamisc.breaking") + ": " + ItemLokiRing.getOnOffString(ItemLokiRing.isRingBreakingEnabled(stack)), list);
        this.addStringToTooltip(StatCollector.func_74838_a((String)"botaniamisc.lokiMirror") + ItemLokiRing.getAxisString(ItemLokiRing.getRingMirrorMode(stack)), list);
        this.addStringToTooltip("", list);
        this.addStringToTooltip(StatCollector.func_74838_a((String)"botaniamisc.lokiToggleDescription") + " " + ItemLokiRing.getOnOffString(true) + EnumChatFormatting.RESET + "/" + ItemLokiRing.getOnOffString(false), list);
        this.addStringToTooltip(StatCollector.func_74838_a((String)"botaniamisc.lokiBreakingDescription") + " " + ItemLokiRing.getOnOffString(true) + EnumChatFormatting.RESET + "/" + ItemLokiRing.getOnOffString(false), list);
        super.func_77624_a(stack, player, list, adv);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ChunkCoordinates> getWireframesToDraw(EntityPlayer player, ItemStack stack) {
        ItemStack lokiRing = ItemLokiRing.getLokiRing(player);
        if (lokiRing != stack || !ItemLokiRing.isRingEnabled(lokiRing)) {
            return null;
        }
        MovingObjectPosition lookPos = Minecraft.func_71410_x().field_71476_x;
        if (lookPos != null && lookPos.field_72308_g == null) {
            List<LokiCursor> list = ItemLokiRing.getCursorList(stack);
            ChunkCoordinates origin = ItemLokiRing.getOriginPos(stack);
            ArrayList<ChunkCoordinates> toDraw = new ArrayList<ChunkCoordinates>();
            if (origin.field_71572_b != -1) {
                for (LokiCursor cursor : list) {
                    ChunkCoordinates coords = cursor.getCoordinates();
                    coords.field_71574_a += origin.field_71574_a;
                    coords.field_71572_b += origin.field_71572_b;
                    coords.field_71573_c += origin.field_71573_c;
                    toDraw.add(coords);
                }
            } else {
                for (LokiCursor cursor : list) {
                    ChunkCoordinates coords = cursor.getCoordinates();
                    coords.field_71574_a += lookPos.field_72311_b;
                    coords.field_71572_b += lookPos.field_72312_c;
                    coords.field_71573_c += lookPos.field_72309_d;
                    toDraw.add(coords);
                }
            }
            return toDraw;
        }
        return null;
    }

    @Override
    public ChunkCoordinates getSourceWireframe(EntityPlayer player, ItemStack stack) {
        return ItemLokiRing.getLokiRing(player) == stack && ItemLokiRing.isRingEnabled(stack) ? ItemLokiRing.getOriginPos(stack) : null;
    }

    public static void clearCursors(ItemStack stack) {
        ItemLokiRing.setCursorList(stack, null);
    }

    public static void clearMasterCursor(ItemStack stack) {
        ItemLokiRing.setOriginPos(stack, 0, -1, 0);
    }

    public static ItemStack getLokiRing(EntityPlayer player) {
        InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
        ItemStack stack1 = baubles.func_70301_a(1);
        ItemStack stack2 = baubles.func_70301_a(2);
        return ItemLokiRing.isLokiRing(stack1) ? stack1 : (ItemLokiRing.isLokiRing(stack2) ? stack2 : null);
    }

    public static int getLokiRingSlot(EntityPlayer player) {
        InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
        ItemStack stack1 = baubles.func_70301_a(1);
        ItemStack stack2 = baubles.func_70301_a(2);
        return ItemLokiRing.isLokiRing(stack1) ? 1 : (ItemLokiRing.isLokiRing(stack2) ? Integer.valueOf(2) : null);
    }

    public static void syncLokiRing(EntityPlayer player) {
        baubles.common.network.PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncBauble(player, ItemLokiRing.getLokiRingSlot(player)), (EntityPlayerMP)player);
    }

    private static boolean isLokiRing(ItemStack stack) {
        return stack != null && (stack.func_77973_b() == ModItems.lokiRing || stack.func_77973_b() == ModItems.aesirRing);
    }

    private static ChunkCoordinates getOriginPos(ItemStack stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_X_ORIGIN, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_Y_ORIGIN, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_Z_ORIGIN, 0);
        return new ChunkCoordinates(x, y, z);
    }

    private static void setOriginPos(ItemStack stack, int x, int y, int z) {
        ItemNBTHelper.setInt(stack, TAG_X_ORIGIN, x);
        ItemNBTHelper.setInt(stack, TAG_Y_ORIGIN, y);
        ItemNBTHelper.setInt(stack, TAG_Z_ORIGIN, z);
    }

    private static List<LokiCursor> getCursorList(ItemStack stack) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound(stack, TAG_CURSOR_LIST, false);
        ArrayList<LokiCursor> cursors = new ArrayList<LokiCursor>();
        int count = cmp.func_74762_e(TAG_CURSOR_COUNT);
        for (int i = 0; i < count; ++i) {
            NBTTagCompound cursorCmp = cmp.func_74775_l(TAG_CURSOR_PREFIX + i);
            cursors.add(LokiCursor.fromNBT(cursorCmp));
        }
        return cursors;
    }

    private static void setCursorList(ItemStack stack, List<LokiCursor> cursors) {
        NBTTagCompound cmp = new NBTTagCompound();
        if (cursors != null) {
            int i = 0;
            for (LokiCursor cursor : cursors) {
                NBTTagCompound cursorCmp = cursor.toNBT();
                cmp.func_74782_a(TAG_CURSOR_PREFIX + i, (NBTBase)cursorCmp);
                ++i;
            }
            cmp.func_74768_a(TAG_CURSOR_COUNT, i);
        }
        ItemNBTHelper.setCompound(stack, TAG_CURSOR_LIST, cmp);
    }

    private static void addCursor(ItemStack stack, int x, int y, int z, byte mirrorMode) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound(stack, TAG_CURSOR_LIST, false);
        int count = cmp.func_74762_e(TAG_CURSOR_COUNT);
        cmp.func_74782_a(TAG_CURSOR_PREFIX + count, (NBTBase)new LokiCursor(x, y, z, mirrorMode).toNBT());
        cmp.func_74768_a(TAG_CURSOR_COUNT, count + 1);
        ItemNBTHelper.setCompound(stack, TAG_CURSOR_LIST, cmp);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInWorld(EntityPlayer player, ItemStack stack) {
        this.renderMirrors(player, stack);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderMirrors(EntityPlayer player, ItemStack stack) {
        ItemStack lokiRing = ItemLokiRing.getLokiRing(player);
        if (lokiRing != stack || !ItemLokiRing.isRingEnabled(lokiRing)) {
            return;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        List<LokiCursor> cursors = ItemLokiRing.getCursorList(stack);
        ChunkCoordinates origin = ItemLokiRing.getOriginPos(stack);
        MovingObjectPosition lookPos = Minecraft.func_71410_x().field_71476_x;
        for (LokiCursor cursor : cursors) {
            AxisAlignedBB axis;
            if (!cursor.isMirror()) continue;
            ChunkCoordinates pos = cursor.getCoordinates();
            if (origin.field_71572_b != -1) {
                pos.field_71574_a += origin.field_71574_a;
                pos.field_71572_b += origin.field_71572_b;
                pos.field_71573_c += origin.field_71573_c;
            } else {
                pos.field_71574_a += lookPos.field_72311_b;
                pos.field_71572_b += lookPos.field_72312_c;
                pos.field_71573_c += lookPos.field_72309_d;
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)((double)pos.field_71574_a - RenderManager.field_78725_b), (double)((double)pos.field_71572_b - RenderManager.field_78726_c), (double)((double)pos.field_71573_c - RenderManager.field_78723_d + 1.0));
            Color colorRGB = new Color(BoundTileRenderer.getWireframeColor());
            GL11.glColor4ub((byte)((byte)colorRGB.getRed()), (byte)((byte)colorRGB.getGreen()), (byte)((byte)colorRGB.getBlue()), (byte)-1);
            Block block = world.func_147439_a(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c);
            if (block != null && (axis = block.func_149633_g((World)world, pos.field_71574_a, pos.field_71572_b, pos.field_71573_c)) != null) {
                axis.field_72340_a -= (double)pos.field_71574_a;
                axis.field_72336_d -= (double)pos.field_71574_a;
                axis.field_72338_b -= (double)pos.field_71572_b;
                axis.field_72337_e -= (double)pos.field_71572_b;
                axis.field_72339_c -= (double)(pos.field_71573_c + 1);
                axis.field_72334_f -= (double)(pos.field_71573_c + 1);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glLineWidth((float)1.0f);
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78371_b(1);
                if (cursor.isMirrorX()) {
                    tessellator.func_78377_a(axis.field_72340_a, axis.field_72338_b, axis.field_72339_c);
                    tessellator.func_78377_a(axis.field_72340_a, axis.field_72337_e, axis.field_72334_f);
                    tessellator.func_78377_a(axis.field_72340_a, axis.field_72337_e, axis.field_72339_c);
                    tessellator.func_78377_a(axis.field_72340_a, axis.field_72338_b, axis.field_72334_f);
                    tessellator.func_78377_a(axis.field_72336_d, axis.field_72338_b, axis.field_72339_c);
                    tessellator.func_78377_a(axis.field_72336_d, axis.field_72337_e, axis.field_72334_f);
                    tessellator.func_78377_a(axis.field_72336_d, axis.field_72337_e, axis.field_72339_c);
                    tessellator.func_78377_a(axis.field_72336_d, axis.field_72338_b, axis.field_72334_f);
                }
                if (cursor.isMirrorY()) {
                    tessellator.func_78377_a(axis.field_72340_a, axis.field_72338_b, axis.field_72339_c);
                    tessellator.func_78377_a(axis.field_72336_d, axis.field_72338_b, axis.field_72334_f);
                    tessellator.func_78377_a(axis.field_72336_d, axis.field_72338_b, axis.field_72339_c);
                    tessellator.func_78377_a(axis.field_72340_a, axis.field_72338_b, axis.field_72334_f);
                    tessellator.func_78377_a(axis.field_72340_a, axis.field_72337_e, axis.field_72339_c);
                    tessellator.func_78377_a(axis.field_72336_d, axis.field_72337_e, axis.field_72334_f);
                    tessellator.func_78377_a(axis.field_72336_d, axis.field_72337_e, axis.field_72339_c);
                    tessellator.func_78377_a(axis.field_72340_a, axis.field_72337_e, axis.field_72334_f);
                }
                if (cursor.isMirrorZ()) {
                    tessellator.func_78377_a(axis.field_72340_a, axis.field_72338_b, axis.field_72339_c);
                    tessellator.func_78377_a(axis.field_72336_d, axis.field_72337_e, axis.field_72339_c);
                    tessellator.func_78377_a(axis.field_72340_a, axis.field_72337_e, axis.field_72339_c);
                    tessellator.func_78377_a(axis.field_72336_d, axis.field_72338_b, axis.field_72339_c);
                    tessellator.func_78377_a(axis.field_72340_a, axis.field_72338_b, axis.field_72334_f);
                    tessellator.func_78377_a(axis.field_72336_d, axis.field_72337_e, axis.field_72334_f);
                    tessellator.func_78377_a(axis.field_72340_a, axis.field_72337_e, axis.field_72334_f);
                    tessellator.func_78377_a(axis.field_72336_d, axis.field_72338_b, axis.field_72334_f);
                }
                tessellator.func_78381_a();
            }
            GL11.glPopMatrix();
        }
    }

    public static enum HUD_MESSAGE {
        MODE,
        BREAKING,
        CLEAR,
        MIRROR,
        INSUFFICIENT_MANA;

    }
}

