/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui.bags;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import vazkii.botania.common.item.bag.ItemBagBase;

public abstract class InventoryMagicPlantBag
implements IInventory {
    private static final ItemStack[] FALLBACK_INVENTORY = new ItemStack[16];
    EntityPlayer player;
    int slot;
    ItemStack[] stacks = null;
    boolean invPushed = false;
    ItemStack storedInv = null;

    public InventoryMagicPlantBag(EntityPlayer player, int slot) {
        this.player = player;
        this.slot = slot;
    }

    ItemStack getStack() {
        ItemStack stack = this.player.field_71071_by.func_70301_a(this.slot);
        if (stack != null) {
            this.storedInv = stack;
        }
        return stack;
    }

    public void pushInventory() {
        if (this.invPushed) {
            return;
        }
        ItemStack stack = this.getStack();
        if (stack == null) {
            stack = this.storedInv;
        }
        if (stack != null) {
            ItemStack[] inv = this.getInventory();
            ItemBagBase.setStacks(stack, inv);
        }
        this.invPushed = true;
    }

    ItemStack[] getInventory() {
        if (this.stacks != null) {
            return this.stacks;
        }
        ItemStack stack = this.getStack();
        if (this.isMagicPlantBag(this.getStack())) {
            this.stacks = ItemBagBase.loadStacks(stack);
            return this.stacks;
        }
        return FALLBACK_INVENTORY;
    }

    public int func_70302_i_() {
        return 16;
    }

    public ItemStack func_70301_a(int slotIn) {
        return this.getInventory()[slotIn];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack[] inventorySlots = this.getInventory();
        if (inventorySlots[index] != null) {
            if (inventorySlots[index].field_77994_a <= count) {
                ItemStack stackAt = inventorySlots[index];
                inventorySlots[index] = null;
                return stackAt;
            }
            ItemStack stackAt = inventorySlots[index].func_77979_a(count);
            if (inventorySlots[index].field_77994_a == 0) {
                inventorySlots[index] = null;
            }
            return stackAt;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return this.func_70301_a(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack[] inventorySlots = this.getInventory();
        inventorySlots[index] = stack;
    }

    public String func_145825_b() {
        return this.getBagName();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.isMagicPlantBag(this.getStack()) ? 64 : 0;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.isMagicPlantBag(this.getStack());
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isMagicPlantBag(this.getStack());
    }

    protected abstract String getBagName();

    public abstract boolean isMagicPlantBag(ItemStack var1);
}

