/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.crossmod.thaumcraft;

import appeng.api.networking.IGrid;
import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import com.glodblock.github.util.ModAndClassUtil;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.grid.IEssentiaGrid;
import thaumicenergistics.common.items.ItemCraftingAspect;

public class ThaumicEnergisticsCrafting {
    public static Item neiAddonAspect;
    public static Item thaumicEnergisticsAspect;

    public static void postInit() {
        neiAddonAspect = GameRegistry.findItem((String)"thaumcraftneiplugin", (String)"Aspect");
        thaumicEnergisticsAspect = GameRegistry.findItem((String)"thaumicenergistics", (String)"crafting.aspect");
    }

    public static boolean isAspectStack(ItemStack stack) {
        if (!ModAndClassUtil.ThE || stack == null) {
            return false;
        }
        return stack.func_77973_b() == neiAddonAspect || stack.func_77973_b() == thaumicEnergisticsAspect;
    }

    @Optional.Method(modid="thaumicenergistics")
    @Nullable
    private static Aspect getAspect(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() == neiAddonAspect) {
            NBTBase nBTBase;
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null || !((nBTBase = tag.func_74781_a("Aspects")) instanceof NBTTagList)) {
                return null;
            }
            NBTTagList aspects = (NBTTagList)nBTBase;
            if (aspects.func_74745_c() != 1) {
                return null;
            }
            String aspect = aspects.func_150305_b(0).func_74779_i("key");
            if (aspect.isEmpty()) {
                return null;
            }
            return Aspect.getAspect((String)aspect);
        }
        if (stack.func_77973_b() == thaumicEnergisticsAspect) {
            return Aspect.getAspect((String)ItemCraftingAspect.getAspect((ItemStack)stack).getTag());
        }
        return null;
    }

    @Optional.Method(modid="thaumicenergistics")
    private static ItemStack getAspectStack(Aspect aspect, int stackSize) {
        return ItemCraftingAspect.createStackForAspect((Aspect)aspect, (int)stackSize);
    }

    public static IAEItemStack convertAspectStack(IAEItemStack stack) {
        if (ModAndClassUtil.ThE) {
            return ThaumicEnergisticsCrafting.convertAspectStackImpl(stack);
        }
        return stack;
    }

    @Optional.Method(modid="thaumicenergistics")
    private static IAEItemStack convertAspectStackImpl(IAEItemStack stack) {
        if (stack == null) {
            return null;
        }
        Aspect aspect = ThaumicEnergisticsCrafting.getAspect(stack.getItemStack());
        if (aspect == null) {
            return stack;
        }
        return (IAEItemStack)Objects.requireNonNull(AEItemStack.create((ItemStack)ThaumicEnergisticsCrafting.getAspectStack(aspect, 1))).setStackSize(stack.getStackSize());
    }

    public static long getEssentiaAmount(IAEItemStack stack, IGrid grid) {
        if (ModAndClassUtil.ThE) {
            return ThaumicEnergisticsCrafting.getEssentiaAmountImpl(stack, grid);
        }
        return 0L;
    }

    @Optional.Method(modid="thaumicenergistics")
    private static long getEssentiaAmountImpl(IAEItemStack stack, IGrid grid) {
        Aspect aspect = ThaumicEnergisticsCrafting.getAspect(stack.getItemStack());
        if (aspect == null) {
            return 0L;
        }
        IEssentiaGrid essentiaGrid = (IEssentiaGrid)grid.getCache(IEssentiaGrid.class);
        return essentiaGrid.getEssentiaAmount(aspect);
    }
}

