/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.me;

import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.core.AEConfig;
import com.glodblock.github.client.me.FluidRepo;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.crossmod.thaumcraft.AspectUtil;
import com.glodblock.github.util.FluidSorters;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import net.minecraftforge.fluids.Fluid;

public class EssentiaRepo
extends FluidRepo {
    public EssentiaRepo(IScrollSource src, ISortSource sortSrc) {
        super(src, sortSrc);
    }

    @Override
    public void updateView() {
        if (this.paused) {
            for (int i = 0; i < this.view.size(); ++i) {
                IAEItemStack entry = (IAEItemStack)this.view.get(i);
                IAEItemStack serverEntry = (IAEItemStack)this.list.findPrecise((IAEStack)entry);
                if (serverEntry == null) {
                    entry.setStackSize(0L);
                    continue;
                }
                this.view.set(i, serverEntry);
            }
            HashSet viewSet = new HashSet(this.view);
            ArrayList<IAEItemStack> entriesToAdd = new ArrayList<IAEItemStack>();
            for (IAEItemStack serverEntry : this.list) {
                if (viewSet.contains(serverEntry)) continue;
                entriesToAdd.add(serverEntry);
            }
            this.addEntriesToView(entriesToAdd);
        } else {
            this.view.clear();
            this.view.ensureCapacity(this.list.size());
            this.addEntriesToView((Iterable<IAEItemStack>)this.list);
        }
        if (!this.paused) {
            Enum SortBy = this.sortSrc.getSortBy();
            Enum SortDir2 = this.sortSrc.getSortDir();
            FluidSorters.setDirection((SortDir)SortDir2);
            FluidSorters.init();
            if (SortBy == SortOrder.MOD) {
                this.view.sort(FluidSorters.CONFIG_BASED_SORT_BY_MOD);
            } else if (SortBy == SortOrder.AMOUNT) {
                this.view.sort(FluidSorters.CONFIG_BASED_SORT_BY_SIZE);
            } else if (SortBy == SortOrder.INVTWEAKS) {
                this.view.sort(FluidSorters.CONFIG_BASED_SORT_BY_INV_TWEAKS);
            } else {
                this.view.sort(FluidSorters.CONFIG_BASED_SORT_BY_NAME);
            }
        }
        this.dsp.clear();
        this.dsp.ensureCapacity(this.list.size());
        for (IAEItemStack is : this.view) {
            this.dsp.add(is.getItemStack());
        }
    }

    private void addEntriesToView(Iterable<IAEItemStack> entries) {
        Pattern m;
        String innerSearch;
        Enum viewMode = this.sortSrc.getSortDisplay();
        Enum searchMode = AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE);
        if (searchMode == SearchBoxMode.NEI_AUTOSEARCH || searchMode == SearchBoxMode.NEI_MANUAL_SEARCH) {
            this.updateNEI(this.searchString);
        }
        if ((innerSearch = this.searchString).startsWith("@")) {
            innerSearch = innerSearch.substring(1);
        }
        try {
            m = Pattern.compile(innerSearch.toLowerCase(), 2);
        }
        catch (Throwable ignore) {
            try {
                m = Pattern.compile(Pattern.quote(innerSearch.toLowerCase()), 2);
            }
            catch (Throwable __) {
                return;
            }
        }
        for (IAEItemStack is : entries) {
            Fluid fluid;
            if (!AspectUtil.isEssentiaGas(ItemFluidDrop.getAeFluidStack(is)) || this.myPartitionList != null && !this.myPartitionList.isListed((IAEStack)is) || viewMode == ViewItems.CRAFTABLE && !is.isCraftable()) continue;
            if (viewMode == ViewItems.CRAFTABLE) {
                is = is.copy();
                is.setStackSize(0L);
            }
            if (viewMode == ViewItems.STORED && is.getStackSize() == 0L || !AspectUtil.isEssentiaGas(fluid = ItemFluidDrop.getAeFluidStack(is).getFluid()) || !m.matcher(fluid.getLocalizedName().toLowerCase()).find()) continue;
            this.view.add(is);
        }
    }
}

