/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container.base;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.definitions.IDefinitions;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotFake;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotPatternTerm;
import appeng.container.slot.SlotRestrictedInput;
import appeng.helpers.IContainerCraftingPacket;
import appeng.helpers.InventoryAction;
import appeng.items.misc.ItemEncodedPattern;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.glodblock.github.client.gui.container.ContainerItemMonitor;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidEncodedPattern;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.inventory.IPatternConsumer;
import com.glodblock.github.inventory.item.IItemPatternTerminal;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.glodblock.github.util.FluidPatternDetails;
import com.glodblock.github.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public abstract class FCContainerEncodeTerminal
extends ContainerItemMonitor
implements IAEAppEngInventory,
IOptionalSlotHost,
IContainerCraftingPacket,
IPatternConsumer {
    public static final int MULTIPLE_OF_BUTTON_CLICK = 2;
    public static final int MULTIPLE_OF_BUTTON_CLICK_ON_SHIFT = 8;
    protected final IItemPatternTerminal patternTerminal;
    protected final AppEngInternalInventory cOut = new AppEngInternalInventory(null, 1);
    protected final IInventory crafting;
    protected final SlotRestrictedInput patternSlotIN;
    protected final SlotRestrictedInput patternSlotOUT;
    protected SlotFake[] craftingSlots;
    protected OptionalSlotFake[] outputSlots;
    protected SlotPatternTerm craftSlot;
    @GuiSync(value=97)
    public boolean craftingMode = true;
    @GuiSync(value=96)
    public boolean substitute = false;
    @GuiSync(value=95)
    public boolean combine = false;
    @GuiSync(value=94)
    public boolean beSubstitute = false;
    @GuiSync(value=93)
    public boolean inverted;
    @GuiSync(value=92)
    public int activePage = 0;
    @GuiSync(value=91)
    public boolean prioritize = false;
    @GuiSync(value=90)
    public boolean autoFillPattern = false;

    public FCContainerEncodeTerminal(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable);
        this.patternTerminal = (IItemPatternTerminal)monitorable;
        this.inverted = this.patternTerminal.isInverted();
        IInventory patternInv = this.patternTerminal.getInventoryByName("pattern");
        this.crafting = this.patternTerminal.getInventoryByName("crafting");
        this.patternSlotIN = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.BLANK_PATTERN, patternInv, 0, 147, -81, this.getInventoryPlayer());
        this.func_75146_a((Slot)this.patternSlotIN);
        this.patternSlotOUT = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, patternInv, 1, 147, -38, this.getInventoryPlayer());
        this.func_75146_a((Slot)this.patternSlotOUT);
        this.patternSlotOUT.setStackLimit(1);
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slotId, long id) {
        if (this.isCraftingMode()) {
            super.doAction(player, action, slotId, id);
            return;
        }
        if (slotId < 0 || slotId >= this.field_75151_b.size()) {
            super.doAction(player, action, slotId, id);
            return;
        }
        if (action == InventoryAction.MOVE_REGION) {
            super.doAction(player, InventoryAction.MOVE_REGION, slotId, id);
            return;
        }
        if (action == InventoryAction.PICKUP_SINGLE) {
            super.doAction(player, InventoryAction.PICKUP_OR_SET_DOWN, slotId, id);
            return;
        }
        Slot slot = this.func_75139_a(slotId);
        ItemStack stack = player.field_71071_by.func_70445_o();
        FluidStack fluid = Util.getFluidFromItem(stack);
        if (fluid == null || fluid.amount <= 0) {
            super.doAction(player, action, slotId, id);
            return;
        }
        if (this.validPatternSlot(slot)) {
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    slot.func_75215_d(ItemFluidPacket.newStack(fluid));
                    return;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    fluid = Util.getFluidFromItem(Util.copyStackWithSize(stack, 1));
                    FluidStack origin = ItemFluidPacket.getFluidStack(slot.func_75211_c());
                    if (fluid != null && fluid.equals((Object)origin)) {
                        fluid.amount += origin.amount;
                        if (fluid.amount <= 0) {
                            fluid = null;
                        }
                    }
                    slot.func_75215_d(ItemFluidPacket.newStack(fluid));
                    return;
                }
            }
        }
        super.doAction(player, action, slotId, id);
    }

    protected abstract boolean validPatternSlot(Slot var1);

    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        Slot clickSlot = (Slot)this.field_75151_b.get(idx);
        ItemStack is = clickSlot.func_75211_c();
        if (is != null && !this.patternSlotOUT.func_75216_d() && is.field_77994_a == 1 && (is.func_77973_b() instanceof ItemFluidEncodedPattern || is.func_77973_b() instanceof ItemEncodedPattern)) {
            ItemStack output = is.func_77946_l();
            this.patternSlotOUT.func_75215_d(output);
            p.field_71071_by.func_70299_a(clickSlot.getSlotIndex(), null);
            this.func_75142_b();
            return null;
        }
        return super.func_82846_b(p, idx);
    }

    public IItemPatternTerminal getPatternTerminal() {
        return this.patternTerminal;
    }

    protected static boolean canDoubleStacks(SlotFake[] slots) {
        List enabledSlots = Arrays.stream(slots).filter(AppEngSlot::isEnabled).collect(Collectors.toList());
        long emptySlots = enabledSlots.stream().filter(s -> s.func_75211_c() == null).count();
        long fullSlots = enabledSlots.stream().filter(s -> s.func_75211_c() != null && s.func_75211_c().field_77994_a * 2 > 127).count();
        return fullSlots <= emptySlots;
    }

    protected static void doubleStacksInternal(SlotFake[] slots) {
        ArrayList<ItemStack> overFlowStacks = new ArrayList<ItemStack>();
        List enabledSlots = Arrays.stream(slots).filter(AppEngSlot::isEnabled).collect(Collectors.toList());
        for (Slot s : enabledSlots) {
            ItemStack st = s.func_75211_c();
            if (st == null) continue;
            if (Util.isFluidPacket(st)) {
                FluidStack fluidStack = ItemFluidPacket.getFluidStack(st);
                if (fluidStack != null) {
                    fluidStack = ItemFluidPacket.getFluidStack(st).copy();
                    if (fluidStack.amount < 0x3FFFFFFF) {
                        fluidStack.amount *= 2;
                    }
                }
                s.func_75215_d(ItemFluidPacket.newStack(fluidStack));
                continue;
            }
            if (st.field_77994_a * 2 > 127) {
                overFlowStacks.add(st.func_77946_l());
                continue;
            }
            st.field_77994_a *= 2;
            s.func_75215_d(st);
        }
        Iterator ow = overFlowStacks.iterator();
        for (Slot s : enabledSlots) {
            if (!ow.hasNext()) break;
            if (s.func_75211_c() != null) continue;
            s.func_75215_d((ItemStack)ow.next());
        }
        assert (!ow.hasNext());
    }

    protected static boolean containsItem(SlotFake[] slots) {
        List enabledSlots = Arrays.stream(slots).filter(AppEngSlot::isEnabled).collect(Collectors.toList());
        long item = enabledSlots.stream().filter(s -> s.func_75211_c() != null && !Util.isFluidPacket(s.func_75211_c())).count();
        return item > 0L;
    }

    protected static boolean containsFluid(SlotFake[] slots) {
        List enabledSlots = Arrays.stream(slots).filter(AppEngSlot::isEnabled).collect(Collectors.toList());
        long fluid = enabledSlots.stream().filter(s -> Util.isFluidPacket(s.func_75211_c())).count();
        return fluid > 0L;
    }

    protected static boolean nonNullSlot(SlotFake[] slots) {
        List enabledSlots = Arrays.stream(slots).filter(AppEngSlot::isEnabled).collect(Collectors.toList());
        long object = enabledSlots.stream().filter(s -> s.func_75211_c() != null).count();
        return object > 0L;
    }

    protected boolean checkHasFluidPattern() {
        if (this.craftingMode) {
            return false;
        }
        boolean hasFluid = FCContainerEncodeTerminal.containsFluid(this.craftingSlots);
        boolean search = FCContainerEncodeTerminal.nonNullSlot(this.craftingSlots);
        if (!search) {
            return false;
        }
        search = FCContainerEncodeTerminal.nonNullSlot((SlotFake[])this.outputSlots);
        return (hasFluid |= FCContainerEncodeTerminal.containsFluid((SlotFake[])this.outputSlots)) && search;
    }

    protected ItemStack stampAuthor(ItemStack patternStack) {
        if (patternStack.field_77990_d == null) {
            patternStack.field_77990_d = new NBTTagCompound();
        }
        patternStack.field_77990_d.func_74778_a("author", this.getPlayerInv().field_70458_d.func_70005_c_());
        return patternStack;
    }

    protected void encodeFluidPattern() {
        ItemStack patternStack = new ItemStack((Item)ItemAndBlockHolder.PATTERN);
        FluidPatternDetails pattern = new FluidPatternDetails(patternStack);
        pattern.setInputs(FCContainerEncodeTerminal.collectInventory((Slot[])this.craftingSlots));
        pattern.setOutputs(FCContainerEncodeTerminal.collectInventory((Slot[])this.outputSlots));
        pattern.setCanBeSubstitute(this.beSubstitute ? 1 : 0);
        this.patternSlotOUT.func_75215_d(this.stampAuthor(pattern.writeToStack()));
    }

    protected static IAEItemStack[] collectInventory(Slot[] slots) {
        IAEItemStack[] stacks = new IAEItemStack[slots.length];
        for (int i = 0; i < stacks.length; ++i) {
            IAEItemStack dropStack;
            ItemStack stack = slots[i].func_75211_c();
            if (stack != null && stack.func_77973_b() instanceof ItemFluidPacket && (dropStack = ItemFluidDrop.newAeStack(ItemFluidPacket.getFluidStack(stack))) != null) {
                stacks[i] = dropStack;
                continue;
            }
            AEItemStack aeStack = AEItemStack.create((ItemStack)stack);
            stacks[i] = aeStack;
        }
        return stacks;
    }

    public void saveChanges() {
    }

    public void clear() {
        for (SlotFake slotFake : this.craftingSlots) {
            slotFake.func_75215_d(null);
        }
        for (SlotFake slotFake : this.outputSlots) {
            slotFake.func_75215_d(null);
        }
        this.func_75142_b();
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    public void encodeAndMoveToInventory() {
        this.encode();
        ItemStack output = this.patternSlotOUT.func_75211_c();
        if (output != null) {
            if (!this.getPlayerInv().func_70441_a(output)) {
                this.getPlayerInv().field_70458_d.func_70099_a(output, 0.0f);
            }
            this.patternSlotOUT.func_75215_d(null);
        }
        this.fillPattern();
    }

    public void encodeAllItemAndMoveToInventory() {
        this.encode();
        ItemStack output = this.patternSlotOUT.func_75211_c();
        if (output != null) {
            if (this.patternSlotIN.func_75211_c() != null) {
                output.field_77994_a += this.patternSlotIN.func_75211_c().field_77994_a;
            }
            if (!this.getPlayerInv().func_70441_a(output)) {
                this.getPlayerInv().field_70458_d.func_70099_a(output, 0.0f);
            }
            this.patternSlotOUT.func_75215_d(null);
            this.patternSlotIN.func_75215_d(null);
        }
        this.fillPattern();
    }

    private void fillPattern() {
        if (this.autoFillPattern && this.getHost().getItemInventory() != null) {
            int fillStackSize;
            IDefinitions definitions = AEApi.instance().definitions();
            int n = fillStackSize = this.patternSlotIN.func_75216_d() ? 64 - this.patternSlotIN.func_75211_c().field_77994_a : 64;
            if (fillStackSize == 0) {
                return;
            }
            for (ItemStack blankPattern : definitions.materials().blankPattern().maybeStack(fillStackSize).asSet()) {
                ItemStack outPattern;
                IAEItemStack out;
                IAEItemStack iBlankPattern = AEApi.instance().storage().createItemStack(blankPattern);
                if (this.patternSlotIN.func_75216_d() && !iBlankPattern.isSameType(this.patternSlotIN.func_75211_c()) || (out = (IAEItemStack)this.getHost().getItemInventory().extractItems((IAEStack)iBlankPattern, Actionable.MODULATE, this.getActionSource())) == null) continue;
                if (this.patternSlotIN.func_75216_d()) {
                    outPattern = this.patternSlotIN.func_75211_c().func_77946_l();
                    outPattern.field_77994_a += out.getItemStack().field_77994_a;
                } else {
                    outPattern = out.getItemStack();
                }
                this.patternSlotIN.func_75215_d(outPattern);
                return;
            }
        }
    }

    public void encode() {
        this.fillPattern();
        if (!this.checkHasFluidPattern()) {
            this.encodeItemPattern();
            return;
        }
        ItemStack stack = this.patternSlotOUT.func_75211_c();
        if (stack == null) {
            stack = this.patternSlotIN.func_75211_c();
            if (this.notPattern(stack)) {
                return;
            }
            if (stack.field_77994_a == 1) {
                this.patternSlotIN.func_75215_d(null);
            } else {
                --stack.field_77994_a;
            }
            this.encodeFluidPattern();
        } else if (!this.notPattern(stack)) {
            this.encodeFluidPattern();
        }
    }

    public void encodeItemPattern() {
        ItemStack encodedPatternStack;
        Iterator iterator;
        ItemStack output = this.patternSlotOUT.func_75211_c();
        ItemStack[] in = this.getInputs();
        ItemStack[] out = this.getOutputs();
        if (in == null || out == null) {
            return;
        }
        if (output != null && this.notPattern(output)) {
            return;
        }
        if (output == null) {
            output = this.patternSlotIN.func_75211_c();
            if (this.notPattern(output)) {
                return;
            }
            --output.field_77994_a;
            if (output.field_77994_a == 0) {
                this.patternSlotIN.func_75215_d(null);
            }
            iterator = AEApi.instance().definitions().items().encodedPattern().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                output = encodedPatternStack = (ItemStack)iterator.next();
            }
        } else if (output.func_77973_b() instanceof ItemFluidEncodedPattern) {
            iterator = AEApi.instance().definitions().items().encodedPattern().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                output = encodedPatternStack = (ItemStack)iterator.next();
            }
        }
        NBTTagCompound encodedValue = new NBTTagCompound();
        NBTTagList tagIn = new NBTTagList();
        NBTTagList tagOut = new NBTTagList();
        for (ItemStack i : in) {
            tagIn.func_74742_a(this.createItemTag(i));
        }
        for (ItemStack i : out) {
            tagOut.func_74742_a(this.createItemTag(i));
        }
        encodedValue.func_74782_a("in", (NBTBase)tagIn);
        encodedValue.func_74782_a("out", (NBTBase)tagOut);
        encodedValue.func_74757_a("crafting", this.craftingMode);
        encodedValue.func_74757_a("substitute", this.substitute);
        encodedValue.func_74757_a("beSubstitute", this.beSubstitute);
        encodedValue.func_74757_a("prioritize", this.prioritize);
        output.func_77982_d(encodedValue);
        this.stampAuthor(output);
        this.patternSlotOUT.func_75215_d(output);
    }

    protected ItemStack[] getInputs() {
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        for (SlotFake craftingSlot : this.craftingSlots) {
            input.add(craftingSlot.func_75211_c());
        }
        if (input.stream().anyMatch(Objects::nonNull)) {
            return input.toArray(new ItemStack[0]);
        }
        return null;
    }

    protected ItemStack[] getOutputs() {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (OptionalSlotFake outputSlot : this.outputSlots) {
            output.add(outputSlot.func_75211_c());
        }
        if (output.stream().anyMatch(Objects::nonNull)) {
            return output.toArray(new ItemStack[0]);
        }
        return null;
    }

    protected boolean notPattern(ItemStack output) {
        if (output == null) {
            return true;
        }
        if (output.func_77973_b() instanceof ItemFluidEncodedPattern) {
            return false;
        }
        IDefinitions definitions = AEApi.instance().definitions();
        boolean isPattern = definitions.items().encodedPattern().isSameAs(output);
        return !(isPattern |= definitions.materials().blankPattern().isSameAs(output));
    }

    protected NBTBase createItemTag(ItemStack i) {
        NBTTagCompound c = new NBTTagCompound();
        if (i != null) {
            Util.writeItemStackToNBT(i, c);
        }
        return c;
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (Platform.isServer()) {
            this.substitute = this.patternTerminal.isSubstitution();
            this.combine = this.patternTerminal.shouldCombine();
            this.beSubstitute = this.patternTerminal.canBeSubstitute();
            this.prioritize = this.patternTerminal.isPrioritize();
            this.autoFillPattern = this.patternTerminal.isAutoFillPattern();
        }
    }

    public void onSlotChange(Slot s) {
        if (s == this.patternSlotOUT && Platform.isServer()) {
            for (Object crafter : this.field_75149_d) {
                ICrafting icrafting = (ICrafting)crafter;
                for (Object g : this.field_75151_b) {
                    if (!(g instanceof OptionalSlotFake) && !(g instanceof SlotFakeCraftingMatrix)) continue;
                    Slot sri = (Slot)g;
                    icrafting.func_71111_a((Container)this, sri.field_75222_d, sri.func_75211_c());
                }
                ((EntityPlayerMP)icrafting).field_71137_h = false;
            }
            this.func_75142_b();
        }
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("player")) {
            return this.getInventoryPlayer();
        }
        return this.patternTerminal.getInventoryByName(name);
    }

    public boolean useRealItems() {
        return false;
    }

    public void doubleStacks(int val) {
        this.multiplyOrDivideStacks(((val & 1) != 0 ? 8 : 2) * ((val & 2) != 0 ? -1 : 1));
    }

    static boolean canMultiplyOrDivide(SlotFake[] slots, int mult) {
        if (mult > 0) {
            for (SlotFake s : slots) {
                long count;
                long result;
                ItemStack st = s.func_75211_c();
                if (st == null || (result = (count = st.func_77973_b() instanceof ItemFluidPacket ? (long)ItemFluidPacket.getFluidAmount(st) : (long)s.func_75211_c().field_77994_a) * (long)mult) <= Integer.MAX_VALUE) continue;
                return false;
            }
            return true;
        }
        if (mult < 0) {
            mult = Math.abs(mult);
            for (SlotFake s : slots) {
                int count;
                ItemStack st = s.func_75211_c();
                if (st == null || (count = st.func_77973_b() instanceof ItemFluidPacket ? ItemFluidPacket.getFluidAmount(st) : s.func_75211_c().field_77994_a) % mult == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static void multiplyOrDivideStacksInternal(SlotFake[] slots, int mult) {
        block5: {
            List enabledSlots;
            block4: {
                enabledSlots = Arrays.stream(slots).filter(AppEngSlot::isEnabled).collect(Collectors.toList());
                if (mult <= 0) break block4;
                for (Slot s : enabledSlots) {
                    ItemStack st = s.func_75211_c();
                    if (st == null) continue;
                    if (st.func_77973_b() instanceof ItemFluidPacket) {
                        ItemFluidPacket.setFluidAmount(st, ItemFluidPacket.getFluidAmount(st) * mult);
                        continue;
                    }
                    st.field_77994_a *= mult;
                    s.func_75215_d(st);
                }
                break block5;
            }
            if (mult >= 0) break block5;
            mult = Math.abs(mult);
            for (Slot s : enabledSlots) {
                ItemStack st = s.func_75211_c();
                if (st == null) continue;
                if (st.func_77973_b() instanceof ItemFluidPacket) {
                    ItemFluidPacket.setFluidAmount(st, ItemFluidPacket.getFluidAmount(st) / mult);
                    continue;
                }
                st.field_77994_a /= mult;
                s.func_75215_d(st);
            }
        }
    }

    public void multiplyOrDivideStacks(int multi) {
        if (!this.isCraftingMode()) {
            if (FCContainerEncodeTerminal.canMultiplyOrDivide(this.craftingSlots, multi) && FCContainerEncodeTerminal.canMultiplyOrDivide((SlotFake[])this.outputSlots, multi)) {
                FCContainerEncodeTerminal.multiplyOrDivideStacksInternal(this.craftingSlots, multi);
                FCContainerEncodeTerminal.multiplyOrDivideStacksInternal((SlotFake[])this.outputSlots, multi);
            }
            this.func_75142_b();
        }
    }

    @Override
    public void acceptPattern(IAEItemStack[] inputs, IAEItemStack[] outputs) {
        if (this.patternTerminal != null) {
            this.patternTerminal.onChangeCrafting(inputs, outputs);
        }
    }

    public boolean isCraftingMode() {
        return this.craftingMode;
    }
}

