/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui;

import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.storage.ITerminalHost;
import appeng.client.gui.implementations.GuiAmount;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.container.implementations.ContainerPatternMulti;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.util.calculators.ArithHelper;
import appeng.util.calculators.Calculator;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.common.item.ItemWirelessUltraTerminal;
import com.glodblock.github.common.parts.PartFluidPatternTerminal;
import com.glodblock.github.common.parts.PartFluidPatternTerminalEx;
import com.glodblock.github.common.parts.PartFluidTerminal;
import com.glodblock.github.common.parts.PartLevelTerminal;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.inventory.item.WirelessLevelTerminalInventory;
import com.glodblock.github.inventory.item.WirelessPatternTerminalInventory;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.glodblock.github.network.CPacketPatternMultiSet;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;

public class GuiPatternMulti
extends GuiAmount {
    private static final int DEFAULT_VALUE = 0;
    private GuiImgButton symbolSwitch;
    protected GuiType originalGui;

    public GuiPatternMulti(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super((Container)new ContainerPatternMulti(inventoryPlayer, te));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.symbolSwitch = new GuiImgButton(this.field_147003_i + 22, this.field_147009_r + 53, (Enum)Settings.ACTIONS, (Enum)ActionItems.MULTIPLY);
        this.field_146292_n.add(this.symbolSwitch);
        this.amountTextField.field_146209_f = this.field_147003_i + 50;
        this.amountTextField.func_146180_a(String.valueOf(0));
        this.amountTextField.func_146199_i(0);
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(GuiText.SelectAmount.getLocal(), 8, 6, GuiColors.CraftAmountSelectAmount.getColor());
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawBG(offsetX, offsetY, mouseX, mouseY);
        this.nextBtn.field_146126_j = GuiText.Set.getLocal();
        try {
            int resultI = this.getAmount();
            this.symbolSwitch.set((Enum)(resultI >= 0 ? ActionItems.MULTIPLY : ActionItems.DIVIDE));
            this.nextBtn.field_146124_l = resultI < -1 || resultI > 1;
        }
        catch (NumberFormatException e) {
            this.nextBtn.field_146124_l = false;
        }
        this.amountTextField.func_146194_f();
    }

    protected void func_146284_a(GuiButton btn) {
        int resultI;
        super.func_146284_a(btn);
        try {
            if (btn == this.nextBtn && btn.field_146124_l && ((resultI = this.getAmount()) > 1 || resultI < -1)) {
                FluidCraft.proxy.netHandler.sendToServer(new CPacketPatternMultiSet(this.originalGui, resultI));
            }
        }
        catch (NumberFormatException e) {
            this.amountTextField.func_146180_a(String.valueOf(0));
        }
        if (btn == this.symbolSwitch) {
            resultI = -this.getAmount();
            this.amountTextField.func_146180_a(Integer.toString(resultI));
        }
    }

    protected int getAmount() {
        String out = this.amountTextField.func_146179_b();
        double resultD = Calculator.conversion((String)out);
        if (Double.isNaN(resultD)) {
            return 0;
        }
        return (int)ArithHelper.round((double)resultD, (int)0);
    }

    protected int addOrderAmount(int i) {
        return i + this.getAmount();
    }

    protected String getBackground() {
        return "guis/patternMulti.png";
    }

    protected void setOriginGUI(Object target) {
        IWirelessTerminal terminal;
        if (target instanceof PartFluidPatternTerminal) {
            this.myIcon = ItemAndBlockHolder.FLUID_TERMINAL.stack();
            this.originalGui = GuiType.FLUID_PATTERN_TERMINAL;
        } else if (target instanceof PartFluidPatternTerminalEx) {
            this.myIcon = ItemAndBlockHolder.FLUID_TERMINAL_EX.stack();
            this.originalGui = GuiType.FLUID_PATTERN_TERMINAL_EX;
        } else if (target instanceof PartFluidTerminal) {
            this.myIcon = ItemAndBlockHolder.FLUID_TERM.stack();
            this.originalGui = GuiType.FLUID_TERMINAL;
        } else if (target instanceof PartLevelTerminal) {
            this.myIcon = ItemAndBlockHolder.LEVEL_TERMINAL.stack();
            this.originalGui = GuiType.LEVEL_TERMINAL;
        } else if (target instanceof IWirelessTerminal && (terminal = (IWirelessTerminal)target).isUniversal(target)) {
            this.myIcon = ItemAndBlockHolder.WIRELESS_ULTRA_TERM.stack();
            this.originalGui = ItemWirelessUltraTerminal.readMode(terminal.getItemStack());
        } else if (target instanceof WirelessPatternTerminalInventory) {
            this.myIcon = ItemAndBlockHolder.WIRELESS_PATTERN_TERM.stack();
            this.originalGui = GuiType.FLUID_TERMINAL;
        } else if (target instanceof WirelessLevelTerminalInventory) {
            this.myIcon = ItemAndBlockHolder.LEVEL_TERMINAL.stack();
            this.originalGui = GuiType.WIRELESS_LEVEL_TERMINAL;
        }
    }
}

