/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.worldgen;

import cubex2.cs3.common.WrappedWorldGen;
import cubex2.cs3.util.SimulatedWorld;
import cubex2.cs3.worldgen.WorldGenCS;
import cubex2.cs3.worldgen.attributes.WorldGenOreAttributes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGenCSOre
extends WorldGenCS {
    private WorldGenOreAttributes worldGen;

    public WorldGenCSOre(WrappedWorldGen wrappedWorldGen) {
        super(wrappedWorldGen);
        this.worldGen = (WorldGenOreAttributes)wrappedWorldGen.container;
    }

    @Override
    public void doGenerate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int generations = MathHelper.func_76141_d((float)this.worldGen.generationsPerChunk);
        for (int i = 0; i < generations; ++i) {
            int x = chunkX * 16 + random.nextInt(16);
            int y = random.nextInt(this.worldGen.maxHeight + 1 - this.worldGen.minHeight) + this.worldGen.minHeight;
            int z = chunkZ * 16 + random.nextInt(16);
            if (!this.shouldGenerate(x, z, world)) continue;
            this.generateAt(random, world, x, y, z);
        }
        if (random.nextFloat() <= this.worldGen.generationsPerChunk - (float)generations) {
            int x = chunkX * 16 + random.nextInt(16);
            int y = random.nextInt(this.worldGen.maxHeight + 1 - this.worldGen.minHeight) + this.worldGen.minHeight;
            int z = chunkZ * 16 + random.nextInt(16);
            if (this.shouldGenerate(x, z, world)) {
                this.generateAt(random, world, x, y, z);
            }
        }
    }

    @Override
    public void generateInSimWorld(SimulatedWorld world, Random random) {
        boolean x = false;
        int y = 0;
        boolean z = false;
        Block block = Block.func_149634_a((Item)this.container.generatedBlock.func_77973_b());
        int meta = this.container.generatedBlock.func_77960_j();
        float angle = random.nextFloat() * (float)Math.PI;
        double d1 = (float)x + MathHelper.func_76126_a((float)angle) * (float)this.worldGen.amount / 8.0f;
        double d2 = (float)x - MathHelper.func_76126_a((float)angle) * (float)this.worldGen.amount / 8.0f;
        double d3 = (float)z + MathHelper.func_76134_b((float)angle) * (float)this.worldGen.amount / 8.0f;
        double d4 = (float)z - MathHelper.func_76134_b((float)angle) * (float)this.worldGen.amount / 8.0f;
        double d5 = y + random.nextInt(3) - 2;
        double d6 = y + random.nextInt(3) - 2;
        int generatedBlocks = 0;
        for (int i = 0; i <= this.worldGen.amount; ++i) {
            double d7 = d1 + (d2 - d1) * (double)i / (double)this.worldGen.amount;
            double d8 = d5 + (d6 - d5) * (double)i / (double)this.worldGen.amount;
            double d9 = d3 + (d4 - d3) * (double)i / (double)this.worldGen.amount;
            double d10 = random.nextDouble() * (double)this.worldGen.amount / 16.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)this.worldGen.amount)) + 1.0f) * d10 + 1.0;
            double d12 = (double)(MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)this.worldGen.amount)) + 1.0f) * d10 + 1.0;
            int minGenX = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int minGenY = MathHelper.func_76128_c((double)(d8 - d12 / 2.0));
            int minGenZ = MathHelper.func_76128_c((double)(d9 - d11 / 2.0));
            int maxGenX = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int maxGenY = MathHelper.func_76128_c((double)(d8 + d12 / 2.0));
            int maxGenZ = MathHelper.func_76128_c((double)(d9 + d11 / 2.0));
            for (int genX = minGenX; genX <= maxGenX; ++genX) {
                double var39 = ((double)genX + 0.5 - d7) / (d11 / 2.0);
                if (!(var39 * var39 < 1.0)) continue;
                for (int genY = minGenY; genY <= maxGenY; ++genY) {
                    double var42 = ((double)genY + 0.5 - d8) / (d12 / 2.0);
                    if (!(var39 * var39 + var42 * var42 < 1.0)) continue;
                    for (int genZ = minGenZ; genZ <= maxGenZ; ++genZ) {
                        double var45 = ((double)genZ + 0.5 - d9) / (d11 / 2.0);
                        if (!(var39 * var39 + var42 * var42 + var45 * var45 < 1.0)) continue;
                        if (generatedBlocks++ < this.worldGen.amount) {
                            world.setBlock(block, genX, genY, genZ);
                            world.setMetadata(meta, genX, genY, genZ);
                            continue;
                        }
                        return;
                    }
                }
            }
        }
    }

    private void generateAt(Random random, World world, int x, int y, int z) {
        Block block = Block.func_149634_a((Item)this.container.generatedBlock.func_77973_b());
        int meta = this.container.generatedBlock.func_77960_j();
        float angle = random.nextFloat() * (float)Math.PI;
        double d1 = (float)(x + 8) + MathHelper.func_76126_a((float)angle) * (float)this.worldGen.amount / 8.0f;
        double d2 = (float)(x + 8) - MathHelper.func_76126_a((float)angle) * (float)this.worldGen.amount / 8.0f;
        double d3 = (float)(z + 8) + MathHelper.func_76134_b((float)angle) * (float)this.worldGen.amount / 8.0f;
        double d4 = (float)(z + 8) - MathHelper.func_76134_b((float)angle) * (float)this.worldGen.amount / 8.0f;
        double d5 = y + random.nextInt(3) - 2;
        double d6 = y + random.nextInt(3) - 2;
        int generatedBlocks = 0;
        for (int i = 0; i <= this.worldGen.amount; ++i) {
            double d7 = d1 + (d2 - d1) * (double)i / (double)this.worldGen.amount;
            double d8 = d5 + (d6 - d5) * (double)i / (double)this.worldGen.amount;
            double d9 = d3 + (d4 - d3) * (double)i / (double)this.worldGen.amount;
            double d10 = random.nextDouble() * (double)this.worldGen.amount / 16.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)this.worldGen.amount)) + 1.0f) * d10 + 1.0;
            double d12 = (double)(MathHelper.func_76126_a((float)((float)i * (float)Math.PI / (float)this.worldGen.amount)) + 1.0f) * d10 + 1.0;
            int minGenX = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int minGenY = MathHelper.func_76128_c((double)(d8 - d12 / 2.0));
            int minGenZ = MathHelper.func_76128_c((double)(d9 - d11 / 2.0));
            int maxGenX = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int maxGenY = MathHelper.func_76128_c((double)(d8 + d12 / 2.0));
            int maxGenZ = MathHelper.func_76128_c((double)(d9 + d11 / 2.0));
            for (int genX = minGenX; genX <= maxGenX; ++genX) {
                double var39 = ((double)genX + 0.5 - d7) / (d11 / 2.0);
                if (!(var39 * var39 < 1.0)) continue;
                for (int genY = minGenY; genY <= maxGenY; ++genY) {
                    double var42 = ((double)genY + 0.5 - d8) / (d12 / 2.0);
                    if (!(var39 * var39 + var42 * var42 < 1.0)) continue;
                    for (int genZ = minGenZ; genZ <= maxGenZ; ++genZ) {
                        double var45 = ((double)genZ + 0.5 - d9) / (d11 / 2.0);
                        if (!(var39 * var39 + var42 * var42 + var45 * var45 < 1.0) || !this.canReplaceBlock(world, genX, genY, genZ)) continue;
                        if (generatedBlocks++ < this.worldGen.amount) {
                            world.func_147465_d(genX, genY, genZ, block, meta, 2);
                            continue;
                        }
                        return;
                    }
                }
            }
        }
    }

    private boolean canReplaceBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != null) {
            int meta = world.func_72805_g(x, y, z);
            return this.canReplaceBlock(world.field_73011_w.field_76574_g, block, meta);
        }
        return false;
    }
}

