/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.worldgen;

import cubex2.cs3.block.BlockCS;
import cubex2.cs3.block.BlockCSFlat;
import cubex2.cs3.common.WrappedWorldGen;
import cubex2.cs3.util.SimulatedWorld;
import cubex2.cs3.worldgen.WorldGenCS;
import cubex2.cs3.worldgen.attributes.WorldGenFlowerAttributes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGenCSFlower
extends WorldGenCS {
    private WorldGenFlowerAttributes worldGen;

    public WorldGenCSFlower(WrappedWorldGen wrappedWorldGen) {
        super(wrappedWorldGen);
        this.worldGen = (WorldGenFlowerAttributes)wrappedWorldGen.container;
    }

    @Override
    protected void doGenerate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int generations = MathHelper.func_76141_d((float)this.worldGen.generationsPerChunk);
        for (int i = 0; i < generations; ++i) {
            int x = chunkX * 16 + random.nextInt(16) + 8;
            int y = random.nextInt(this.worldGen.maxHeight + 1 - this.worldGen.minHeight) + this.worldGen.minHeight;
            int z = chunkZ * 16 + random.nextInt(16) + 8;
            if (!this.shouldGenerate(x, z, world)) continue;
            this.generateAt(random, world, x, y, z);
        }
        if (random.nextFloat() <= this.worldGen.generationsPerChunk - (float)generations) {
            int x = chunkX * 16 + random.nextInt(16) + 8;
            int y = random.nextInt(this.worldGen.maxHeight + 1 - this.worldGen.minHeight) + this.worldGen.minHeight;
            int z = chunkZ * 16 + random.nextInt(16) + 8;
            if (this.shouldGenerate(x, z, world)) {
                this.generateAt(random, world, x, y, z);
            }
        }
    }

    public void generateAt(Random random, World world, int x, int y, int z) {
        Block block = Block.func_149634_a((Item)this.container.generatedBlock.func_77973_b());
        int meta = this.container.generatedBlock.func_77960_j();
        if (block instanceof BlockCS) {
            meta = ((BlockCS)block).getMetaForFlowerGen(meta);
        }
        for (int i = 0; i < this.worldGen.blockRate; ++i) {
            boolean canStay;
            int genZ;
            int genY;
            int genX = x + random.nextInt(8) - random.nextInt(8);
            if (!world.func_147437_c(genX, genY = y + random.nextInt(4) - random.nextInt(4), genZ = z + random.nextInt(8) - random.nextInt(8))) continue;
            boolean bl = canStay = block instanceof BlockCSFlat ? ((BlockCSFlat)block).canBlockStay(world, genX, genY, genZ, meta) : block.func_149718_j(world, genX, genY, genZ);
            if (!canStay || !this.canPlaceBlock(world, genX, genY - 1, genZ)) continue;
            world.func_147465_d(genX, genY, genZ, block, meta, 2);
        }
    }

    private boolean canPlaceBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != null) {
            int meta = world.func_72805_g(x, y, z);
            return this.canReplaceBlock(world.field_73011_w.field_76574_g, block, meta);
        }
        return false;
    }

    @Override
    public void generateInSimWorld(SimulatedWorld world, Random random) {
    }
}

