/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import cubex2.cs3.common.WrappedWorldGen;
import cubex2.cs3.lib.Biomes;
import cubex2.cs3.util.ItemStackHelper;
import cubex2.cs3.util.SimulatedWorld;
import cubex2.cs3.worldgen.attributes.WorldGenAttributes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.ChunkProviderHell;

public abstract class WorldGenCS
implements IWorldGenerator {
    protected WorldGenAttributes container;
    protected WrappedWorldGen wrappedWorldGen;

    public WorldGenCS(WrappedWorldGen wrappedWorldGen) {
        this.wrappedWorldGen = wrappedWorldGen;
        this.container = wrappedWorldGen.container;
    }

    protected abstract void doGenerate(Random var1, int var2, int var3, World var4, IChunkProvider var5, IChunkProvider var6);

    public abstract void generateInSimWorld(SimulatedWorld var1, Random var2);

    protected boolean canReplaceBlock(int dimension, Block block, int meta) {
        block4: {
            ItemStack stack;
            block5: {
                block3: {
                    stack = new ItemStack(block, 1, meta);
                    if (dimension != 0) break block3;
                    for (ItemStack stack1 : this.container.overworldReplacedBlocks) {
                        if (!ItemStackHelper.itemStackEqual(stack, stack1)) continue;
                        return true;
                    }
                    break block4;
                }
                if (dimension != -1) break block5;
                for (ItemStack stack1 : this.container.netherReplacedBlocks) {
                    if (!ItemStackHelper.itemStackEqual(stack, stack1)) continue;
                    return true;
                }
                break block4;
            }
            if (dimension != 1) break block4;
            for (ItemStack stack1 : this.container.endReplacedBlocks) {
                if (!ItemStackHelper.itemStackEqual(stack, stack1)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean shouldGenerate(int x, int z, World world) {
        if (this.container.allowedBiomes[0].equals("all")) {
            return true;
        }
        BiomeGenBase biome = world.func_72807_a(x, z);
        for (String s : this.container.allowedBiomes) {
            if (Biomes.getBiome(s) != biome) continue;
            return true;
        }
        return false;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (this.container.generatedBlock == null) {
            return;
        }
        if (chunkGenerator instanceof ChunkProviderGenerate && !this.container.generateInOverworld) {
            return;
        }
        if (chunkGenerator instanceof ChunkProviderHell && !this.container.generateInNether) {
            return;
        }
        if (chunkGenerator instanceof ChunkProviderEnd && !this.container.generateInEnd) {
            return;
        }
        this.doGenerate(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
    }
}

