/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.util;

import cubex2.cs3.lib.Biomes;
import cubex2.cs3.util.MyBiConsumer;
import cubex2.cs3.util.MyFunction;
import cubex2.cs3.util.NBTData;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.biome.BiomeGenBase;

public class Util {
    public static final MyBiConsumer<ItemStack, NBTTagCompound> NBT_ITEMSTACK_WRITER = new MyBiConsumer<ItemStack, NBTTagCompound>(){

        @Override
        public void accept(ItemStack itemStack, NBTTagCompound nbtTagCompound) {
            if (itemStack != null) {
                itemStack.func_77955_b(nbtTagCompound);
            }
        }
    };
    public static final MyFunction<NBTTagCompound, ItemStack> NBT_ITEMSTACK_READER = new MyFunction<NBTTagCompound, ItemStack>(){

        @Override
        public ItemStack apply(NBTTagCompound nbtTagCompound) {
            return ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
        }
    };
    public static final MyBiConsumer<String, NBTTagCompound> NBT_STRING_WRITER = new MyBiConsumer<String, NBTTagCompound>(){

        @Override
        public void accept(String string, NBTTagCompound nbtTagCompound) {
            if (string != null && string.length() > 0) {
                nbtTagCompound.func_74778_a("string", string);
            }
        }
    };
    public static final MyFunction<NBTTagCompound, String> NBT_STRING_READER = new MyFunction<NBTTagCompound, String>(){

        @Override
        public String apply(NBTTagCompound nbtTagCompound) {
            return nbtTagCompound.func_74779_i("string");
        }
    };
    public static final MyBiConsumer<Integer, NBTTagCompound> NBT_INTEGER_WRITER = new MyBiConsumer<Integer, NBTTagCompound>(){

        @Override
        public void accept(Integer i, NBTTagCompound nbtTagCompound) {
            if (i != null) {
                nbtTagCompound.func_74768_a("int", i.intValue());
            }
        }
    };
    public static final MyFunction<NBTTagCompound, Integer> NBT_INTEGER_READER = new MyFunction<NBTTagCompound, Integer>(){

        @Override
        public Integer apply(NBTTagCompound nbtTagCompound) {
            return nbtTagCompound.func_74762_e("int");
        }
    };
    public static final MyBiConsumer<BiomeGenBase, NBTTagCompound> NBT_BIOME_WRITER = new MyBiConsumer<BiomeGenBase, NBTTagCompound>(){

        @Override
        public void accept(BiomeGenBase biome, NBTTagCompound nbtTagCompound) {
            if (biome != null) {
                nbtTagCompound.func_74778_a("Value", biome.field_76791_y);
            }
        }
    };
    public static final MyFunction<NBTTagCompound, BiomeGenBase> NBT_BIOME_READER = new MyFunction<NBTTagCompound, BiomeGenBase>(){

        @Override
        public BiomeGenBase apply(NBTTagCompound nbtTagCompound) {
            return Biomes.getBiome(nbtTagCompound.func_74779_i("Value"));
        }
    };

    public static void writeStacksToNBT(String name, ItemStack[] stacks, NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            stacks[i].func_77955_b(compound);
            tagList.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a(name, (NBTBase)tagList);
    }

    public static void readStacksFromNBT(String name, ItemStack[] stacks, NBTTagCompound nbt) {
        NBTTagList tagList = nbt.func_150295_c(name, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound = tagList.func_150305_b(i);
            int j = compound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= stacks.length) continue;
            stacks[j] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
    }

    public static <T extends NBTData> void writeListToNBT(String name, Collection<T> list, NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (NBTData data : list) {
            NBTTagCompound compound = new NBTTagCompound();
            data.writeToNBT(compound);
            tagList.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a(name, (NBTBase)tagList);
    }

    public static <T extends NBTData> void readListFromNBT(String name, Collection<T> list, NBTTagCompound nbt, Class<T> clazz) {
        NBTTagList tagList = nbt.func_150295_c(name, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            try {
                NBTTagCompound compound = tagList.func_150305_b(i);
                NBTData data = (NBTData)clazz.newInstance();
                data.readFromNBT(compound);
                list.add(data);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> void writeListToNBT(String listName, List<T> list, MyBiConsumer<T, NBTTagCompound> writer, NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (T t : list) {
            NBTTagCompound compound = new NBTTagCompound();
            writer.accept(t, compound);
            tagList.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a(listName, (NBTBase)tagList);
    }

    public static <T> void readListFromNBT(String listName, List<T> list, MyFunction<NBTTagCompound, T> reader, NBTTagCompound nbt) {
        NBTTagList tagList = nbt.func_150295_c(listName, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound compound = tagList.func_150305_b(i);
            list.add(reader.apply(compound));
        }
    }
}

