/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.util;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class SimulatedWorld
implements IBlockAccess {
    private Block[] blocks;
    private int[] meta;
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;
    private final int xSize;
    private final int ySize;
    private final int zSize;

    public SimulatedWorld(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.xSize = maxX - minX + 1;
        this.ySize = maxY - minY + 1;
        this.zSize = maxZ - minZ + 1;
        this.blocks = new Block[this.xSize * this.ySize * this.zSize];
        this.meta = new int[this.xSize * this.ySize * this.zSize];
    }

    public Block func_147439_a(int x, int y, int z) {
        if (x < this.minX || y < this.minY || z < this.minZ || x > this.maxX || y > this.maxY || z > this.maxZ) {
            return Blocks.field_150350_a;
        }
        Block block = this.blocks[(x += Math.abs(Math.min(0, this.minX))) + (y += Math.abs(Math.min(0, this.minY))) * this.xSize + (z += Math.abs(Math.min(0, this.minZ))) * this.ySize * this.xSize];
        return block == null ? Blocks.field_150350_a : block;
    }

    public void setBlock(Block block, int x, int y, int z) {
        if (x < this.minX || y < this.minY || z < this.minZ || x > this.maxX || y > this.maxY || z > this.maxZ) {
            return;
        }
        this.blocks[(x += Math.abs((int)Math.min((int)0, (int)this.minX))) + (y += Math.abs((int)Math.min((int)0, (int)this.minY))) * this.xSize + (z += Math.abs((int)Math.min((int)0, (int)this.minZ))) * this.ySize * this.xSize] = block;
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        return null;
    }

    public int func_72802_i(int x, int y, int z, int side) {
        return 152;
    }

    public int func_72805_g(int x, int y, int z) {
        if (x < this.minX || y < this.minY || z < this.minZ || x > this.maxX || y > this.maxY || z > this.maxZ) {
            return 0;
        }
        return this.meta[(x += Math.abs(Math.min(0, this.minX))) + (y += Math.abs(Math.min(0, this.minY))) * this.xSize + (z += Math.abs(Math.min(0, this.minZ))) * this.ySize * this.xSize];
    }

    public void setMetadata(int metadata, int x, int y, int z) {
        if (x < this.minX || y < this.minY || z < this.minZ || x > this.maxX || y > this.maxY || z > this.maxZ) {
            return;
        }
        this.meta[(x += Math.abs((int)Math.min((int)0, (int)this.minX))) + (y += Math.abs((int)Math.min((int)0, (int)this.minY))) * this.xSize + (z += Math.abs((int)Math.min((int)0, (int)this.minZ))) * this.ySize * this.xSize] = metadata;
    }

    public int func_72879_k(int x, int y, int z, int side) {
        return 0;
    }

    public boolean func_147437_c(int x, int y, int z) {
        return this.func_147439_a(x, y, z) == Blocks.field_150350_a;
    }

    public BiomeGenBase func_72807_a(int x, int y) {
        return BiomeGenBase.field_76772_c;
    }

    public int func_72800_K() {
        return this.ySize;
    }

    public boolean func_72806_N() {
        return false;
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        if (x < this.minX || y < this.minY || z < this.minZ || x > this.maxX || y > this.maxY || z > this.maxZ) {
            return _default;
        }
        return this.func_147439_a(x, y, z).isSideSolid((IBlockAccess)this, x, y, z, side);
    }

    public void clear() {
        for (int i = 0; i < this.blocks.length; ++i) {
            this.blocks[i] = null;
            this.meta[i] = 0;
        }
    }
}

