/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.util;

import com.google.common.collect.Lists;
import cubex2.cs3.util.ItemStackHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeInput {
    private ItemStack stack;
    private String oreClass;

    public RecipeInput(ItemStack stack) {
        this.stack = stack;
    }

    public RecipeInput(String oreClass) {
        this.oreClass = oreClass;
    }

    public boolean isOreClass() {
        return this.oreClass != null;
    }

    public Object getInput() {
        return this.isOreClass() ? this.oreClass : this.stack;
    }

    public List<ItemStack> getStacks() {
        ArrayList stacks = Lists.newArrayList();
        if (this.stack != null) {
            stacks.add(this.stack.func_77946_l());
        } else {
            stacks.addAll(OreDictionary.getOres((String)this.oreClass));
        }
        return stacks;
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74757_a("IsOre", this.oreClass != null);
        if (this.oreClass != null) {
            compound.func_74778_a("OreClass", this.oreClass);
        } else {
            compound.func_74782_a("Stack", (NBTBase)ItemStackHelper.writeToNBTNamed(this.stack));
        }
    }

    public static RecipeInput loadFromNBT(NBTTagCompound compound) {
        if (!compound.func_74764_b("IsOre")) {
            return null;
        }
        boolean isOre = compound.func_74767_n("IsOre");
        if (isOre) {
            return new RecipeInput(compound.func_74779_i("OreClass"));
        }
        return new RecipeInput(ItemStackHelper.readFromNBTNamed(compound.func_74775_l("Stack")));
    }
}

