/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.util;

import com.google.common.collect.Lists;
import cubex2.cs3.util.PostponableTask;
import java.util.List;

public class PostponeHandler {
    private List<PostponableTask> postponedTasks = Lists.newArrayList();

    public boolean executeTask(PostponableTask task) {
        boolean result = task.doWork();
        if (!result) {
            this.postponedTasks.add(task);
        }
        return result;
    }

    public void addTask(PostponableTask task) {
        this.postponedTasks.add(task);
    }

    public void executePostponedTasks() {
        for (PostponableTask task : this.postponedTasks) {
            boolean result = task.doWork();
            if (result) continue;
            System.err.println("Postponed task failed!");
        }
        this.postponedTasks.clear();
    }
}

