/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraftforge.oredict.OreDictionary;

public final class OreDictionaryClass
implements Comparable<OreDictionaryClass> {
    private static final Map<String, OreDictionaryClass> instances = Maps.newHashMap();
    public final String oreClass;

    public static OreDictionaryClass getInstance(String oreClass) {
        if (!instances.containsKey(oreClass)) {
            instances.put(oreClass, new OreDictionaryClass(oreClass));
        }
        return instances.get(oreClass);
    }

    public static List<OreDictionaryClass> getAllClasses() {
        ArrayList list = Lists.newArrayList();
        for (String s : OreDictionary.getOreNames()) {
            list.add(OreDictionaryClass.getInstance(s));
        }
        return list;
    }

    public static List<OreDictionaryClass> getAllClassesSorted() {
        List<OreDictionaryClass> list = OreDictionaryClass.getAllClasses();
        Collections.sort(list);
        return list;
    }

    private OreDictionaryClass(String oreClass) {
        this.oreClass = oreClass;
    }

    @Override
    public int compareTo(OreDictionaryClass o) {
        return this.oreClass.compareTo(o.oreClass);
    }
}

