/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.util;

import cubex2.cs3.util.ItemStackHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTHelper {
    public static int getCSIntData(NBTTagCompound tag, String name) {
        if (tag == null || !tag.func_74764_b("cs2intData_" + name)) {
            return -1;
        }
        return tag.func_74762_e("cs2intData_" + name);
    }

    public static float getCSFloatData(NBTTagCompound tag, String name) {
        if (tag == null || !tag.func_74764_b("cs2floatData_" + name)) {
            return -1.0f;
        }
        return tag.func_74760_g("cs2floatData_" + name);
    }

    public static String getCSStringData(NBTTagCompound tag, String name) {
        if (tag == null || !tag.func_74764_b("cs2stringData_" + name)) {
            return null;
        }
        return tag.func_74779_i("cs2stringData_" + name);
    }

    public static void setCSIntData(NBTTagCompound tag, String name, int value) {
        if (tag != null) {
            tag.func_74768_a("cs2intData_" + name, value);
        }
    }

    public static void setCSFloatData(NBTTagCompound tag, String name, float value) {
        if (tag != null) {
            tag.func_74776_a("cs2floatData_" + name, value);
        }
    }

    public static void setCSStringData(NBTTagCompound tag, String name, String value) {
        if (tag != null) {
            tag.func_74778_a("cs2stringData_" + name, value);
        }
    }

    public static void dumpNBT(NBTTagCompound tag, File file) {
        try {
            FileWriter w = new FileWriter(file);
            w.write("IMPORTANT:\n");
            w.write("This is just the packs data in a readable format used for debugging stuff.\n");
            w.write("Changes made here have no effect at all. This is intended.\n\n");
            NBTHelper.writeObject("", tag, w, 0);
            w.flush();
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeObject(String name, Object o, FileWriter w, int depth) throws IOException {
        char nl = '\r';
        if (o instanceof NBTTagCompound) {
            NBTTagCompound compound1 = (NBTTagCompound)o;
            Set set = ((NBTTagCompound)o).func_150296_c();
            w.write(NBTHelper.getIndent(depth) + name + "{" + nl);
            for (Object tag : set) {
                String s = (String)tag;
                NBTHelper.writeObject(s + ": ", compound1.func_74781_a(s), w, depth + 1);
            }
            w.write(NBTHelper.getIndent(depth) + "}" + nl);
        } else if (o instanceof NBTTagList) {
            NBTTagList tagList = (NBTTagList)o;
            w.write(NBTHelper.getIndent(depth) + name + "{" + nl);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTHelper.writeObject("[" + i + "]: ", tagList.func_150305_b(i), w, depth + 1);
            }
            w.write(NBTHelper.getIndent(depth) + "}" + nl);
        } else {
            w.write(NBTHelper.getIndent(depth) + name + o.toString() + nl);
        }
    }

    private static String getIndent(int depth) {
        String res = "";
        for (int i = 0; i < depth; ++i) {
            res = res + "   ";
        }
        return res;
    }

    public static void writeToNBT(ItemStack stack, String name, NBTTagCompound nbt) {
        if (stack != null) {
            NBTTagCompound compound = new NBTTagCompound();
            ItemStackHelper.writeToNBTNamed(stack, compound);
            nbt.func_74782_a(name, (NBTBase)compound);
        }
    }

    public static ItemStack readStackFromNBT(String name, NBTTagCompound nbt) {
        if (nbt.func_74764_b(name)) {
            return ItemStackHelper.readFromNBTNamed(nbt.func_74775_l(name));
        }
        return null;
    }
}

