/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.util;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameData;
import cubex2.cs3.util.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackHelper {
    public static void damageItem(ItemStack stack, int amount) {
        if (stack.func_77984_f()) {
            stack.func_77964_b(stack.func_77960_j() + amount);
            if (stack.func_77960_j() > stack.func_77958_k()) {
                --stack.field_77994_a;
                if (stack.field_77994_a < 0) {
                    stack.field_77994_a = 0;
                }
                stack.func_77964_b(0);
            }
        }
    }

    public static boolean hasEnchantment(ItemStack stack, int id, int level) {
        if (!stack.func_77948_v()) {
            return false;
        }
        NBTTagCompound tag = stack.func_77978_p();
        NBTTagList tagList = (NBTTagList)tag.func_74781_a("ench");
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            boolean lvlMatch;
            boolean idMatch;
            NBTTagCompound tag1 = tagList.func_150305_b(i);
            boolean bl = id == -1 ? true : (idMatch = tag1.func_74765_d("id") == id);
            boolean bl2 = level == -1 ? true : (lvlMatch = tag1.func_74765_d("lvl") == level);
            if (!idMatch || !lvlMatch) continue;
            return true;
        }
        return false;
    }

    public static void clearEnchantments(ItemStack stack) {
        if (!stack.func_77948_v()) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_82580_o("ench");
    }

    public static void addEnchantment(ItemStack stack, int id, int level) {
        if (Enchantment.field_77331_b[id] != null) {
            stack.func_77966_a(Enchantment.field_77331_b[id], level);
        }
    }

    public static void removeEnchantment(ItemStack stack, int id) {
        if (ItemStackHelper.hasEnchantment(stack, id, -1)) {
            NBTTagCompound tag = stack.func_77978_p();
            NBTTagList tagList = (NBTTagList)tag.func_74781_a("ench");
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag1 = tagList.func_150305_b(i);
                if (tag1.func_74765_d("id") != id) continue;
                tagList.func_74744_a(i);
                break;
            }
            if (tagList.func_74745_c() == 0) {
                tag.func_82580_o("ench");
            }
        }
    }

    public static int getIntData(ItemStack stack, String name) {
        return NBTHelper.getCSIntData(stack.field_77990_d, name);
    }

    public static float getFloatData(ItemStack stack, String name) {
        return NBTHelper.getCSFloatData(stack.field_77990_d, name);
    }

    public static String getStringData(ItemStack stack, String name) {
        return NBTHelper.getCSStringData(stack.field_77990_d, name);
    }

    public static void setIntData(ItemStack stack, String name, int data) {
        ItemStackHelper.initNBTTag(stack);
        NBTHelper.setCSIntData(stack.field_77990_d, name, data);
    }

    public static void setFloatData(ItemStack stack, String name, float data) {
        ItemStackHelper.initNBTTag(stack);
        NBTHelper.setCSFloatData(stack.field_77990_d, name, data);
    }

    public static void setStringData(ItemStack stack, String name, String data) {
        ItemStackHelper.initNBTTag(stack);
        NBTHelper.setCSStringData(stack.field_77990_d, name, data);
    }

    public static void initNBTTag(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public static List<ItemStack> getSubTypes(Item item) {
        ArrayList stacks = Lists.newArrayList();
        item.func_150895_a(item, null, (List)stacks);
        return stacks;
    }

    public static ArrayList<ItemStack> getAllItemStacks() {
        return ItemStackHelper.getAllItemStacks(true);
    }

    public static ArrayList<ItemStack> getAllItemStacks(boolean wildCardStacks) {
        ArrayList stacks = Lists.newArrayList();
        for (Object o : GameData.getItemRegistry().func_148742_b()) {
            Item item = (Item)GameData.getItemRegistry().func_82594_a(o);
            ArrayList itemStacks = Lists.newArrayList();
            if (item.func_77614_k()) {
                itemStacks.addAll(ItemStackHelper.getSubTypes(item));
                if (wildCardStacks && itemStacks.size() > 1) {
                    itemStacks.add(new ItemStack(item, 1, Short.MAX_VALUE));
                }
            } else if (item.func_77645_m()) {
                itemStacks.add(new ItemStack(item, 1, 0));
                if (wildCardStacks) {
                    itemStacks.add(new ItemStack(item, 1, Short.MAX_VALUE));
                }
            } else {
                itemStacks.add(new ItemStack(item, 1, 0));
            }
            stacks.addAll(itemStacks);
        }
        return stacks;
    }

    public static List<ItemStack> getBlockStacks(boolean wildCardStacks) {
        ArrayList stacks = Lists.newArrayList();
        for (Object o : GameData.getBlockRegistry().func_148742_b()) {
            Block block = (Block)GameData.getBlockRegistry().func_82594_a(o);
            Item item = Item.func_150898_a((Block)block);
            block.func_149666_a(Item.func_150898_a((Block)block), CreativeTabs.field_78027_g, (List)stacks);
            if (item == null || !wildCardStacks || !item.func_77614_k()) continue;
            stacks.add(new ItemStack(item, 1, Short.MAX_VALUE));
        }
        for (int i = 0; i < stacks.size(); ++i) {
            if (((ItemStack)stacks.get(i)).func_77973_b() != null) continue;
            stacks.remove(i--);
        }
        return stacks;
    }

    public static List<ItemStack> getBlockStacks() {
        ArrayList stacks = Lists.newArrayList();
        for (Object o : GameData.getBlockRegistry().func_148742_b()) {
            Block block = (Block)GameData.getBlockRegistry().func_82594_a(o);
            Item item = Item.func_150898_a((Block)block);
            if (item == null || !(item instanceof ItemBlock)) continue;
            if (item.func_77614_k()) {
                ArrayList list = Lists.newArrayList();
                item.func_150895_a(item, CreativeTabs.field_78027_g, (List)list);
                stacks.addAll(list);
                continue;
            }
            stacks.add(new ItemStack(item, 1, 0));
        }
        return stacks;
    }

    public static List<ItemStack> getOreItemStacks(String oreName) {
        ArrayList stacks = Lists.newArrayList();
        ArrayList oreStacks = OreDictionary.getOres((String)oreName);
        for (int i = 0; i < oreStacks.size(); ++i) {
            ItemStack stack = (ItemStack)oreStacks.get(i);
            Item item = stack.func_77973_b();
            if (stack.func_77960_j() == Short.MAX_VALUE && item != null) {
                if (item.func_77614_k()) {
                    stacks.addAll(ItemStackHelper.getSubTypes(item));
                    continue;
                }
                stacks.add(new ItemStack(item, 1, 0));
                continue;
            }
            stacks.add(stack.func_77946_l());
        }
        return stacks;
    }

    public static boolean itemStackEqual(ItemStack is1, ItemStack is2) {
        boolean itemEqual;
        if (is1 == null && is2 == null) {
            return true;
        }
        if (is1 == null ^ is2 == null) {
            return false;
        }
        if (is1.func_77973_b() == null && is2.func_77973_b() == null) {
            return true;
        }
        if (is1.func_77973_b() == null ^ is2.func_77973_b() == null) {
            return false;
        }
        boolean bl = itemEqual = is1.func_77973_b() == is2.func_77973_b();
        boolean damageEqual = is1.func_77960_j() == Short.MAX_VALUE || is2.func_77960_j() == Short.MAX_VALUE ? true : is1.func_77960_j() == is2.func_77960_j();
        return itemEqual && damageEqual;
    }

    public static void writeToNBTNamed(ItemStack stack, NBTTagCompound nbt) {
        nbt.func_74778_a("ItemName", Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
        nbt.func_74774_a("Count", (byte)stack.field_77994_a);
        nbt.func_74777_a("Damage", (short)stack.func_77960_j());
        if (stack.field_77990_d != null) {
            nbt.func_74782_a("tag", (NBTBase)stack.field_77990_d);
        }
    }

    public static NBTTagCompound writeToNBTNamed(ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        ItemStackHelper.writeToNBTNamed(stack, nbt);
        return nbt;
    }

    public static ItemStack readFromNBTNamed(NBTTagCompound compound) {
        if (!compound.func_74764_b("ItemName")) {
            return null;
        }
        ItemStack stack = new ItemStack((Item)null);
        stack.func_150996_a((Item)GameData.getItemRegistry().func_82594_a(compound.func_74779_i("ItemName")));
        if (stack.func_77973_b() == null) {
            return null;
        }
        stack.field_77994_a = compound.func_74771_c("Count");
        stack.func_77964_b((int)compound.func_74765_d("Damage"));
        if (compound.func_150297_b("tag", 10)) {
            stack.field_77990_d = compound.func_74775_l("tag");
        }
        return stack;
    }
}

