/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.util;

import cubex2.cs3.common.BaseContentPack;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class IOHelper {
    public static NBTTagCompound readNBTFromPath(String path, BaseContentPack pack) {
        if (pack.isZipped()) {
            return IOHelper.readNBTFromZip(pack.getDirectory(), path);
        }
        return IOHelper.readNBTFromFile(pack.getDirectory(), path);
    }

    public static NBTTagCompound readNBTFromFile(File modDir, String path) {
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(new File(modDir, path)));
            return nbt;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NBTTagCompound readNBTFromZip(File zipFile, String entryName) {
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipFile);
            ZipEntry entry = zip.getEntry(entryName);
            if (entry != null) {
                NBTTagCompound nbt;
                InputStream stream = zip.getInputStream(entry);
                NBTTagCompound nBTTagCompound = nbt = CompressedStreamTools.func_74796_a((InputStream)stream);
                return nBTTagCompound;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void writeNBTToFile(NBTTagCompound nbt, File file) {
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)new FileOutputStream(file));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to save data.");
        }
    }
}

