/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.util;

import com.google.common.collect.Lists;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.GameData;
import cubex2.cs3.ClientProxy;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.util.ItemStackHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;

public class ClientHelper {
    private static List<ResourceLocation> cachedBlockIcons = null;
    private static List<ResourceLocation> cachedItemIcons = null;

    public static EntityPlayer getPlayer() {
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    public static void refreshResources(Minecraft mc) {
        mc.func_147118_V().func_147689_b();
        mc.func_110436_a();
        mc.func_147118_V().func_147687_e();
    }

    public static String loadDocFile(String path) {
        try {
            InputStream stream = ClientProxy.resPack.func_110590_a(new ResourceLocation("cs3", "docs/" + path));
            String res = IOUtils.toString((InputStream)stream, (Charset)Charsets.UTF_8).replace("\r", "");
            stream.close();
            return res;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "TEXT --{\n[FILE NOT FOUND: " + path + " ]\n}--";
        }
    }

    public static List<ResourceLocation> getAllIcons(String subFolder) {
        if (subFolder.equals("blocks")) {
            return ClientHelper.getAllBlockIcons();
        }
        if (subFolder.equals("items")) {
            return ClientHelper.getAllItemIcons();
        }
        return Lists.newArrayList();
    }

    public static List<ResourceLocation> getAllBlockIcons() {
        if (cachedBlockIcons != null) {
            return cachedBlockIcons;
        }
        cachedBlockIcons = Lists.newArrayList();
        ArrayList names = Lists.newArrayList();
        for (Object o : GameData.getBlockRegistry().func_148742_b()) {
            Block block = (Block)GameData.getBlockRegistry().func_82594_a(o);
            for (int meta = 0; meta < 16; ++meta) {
                for (int side = 0; side < 6; ++side) {
                    try {
                        IIcon icon = block.func_149691_a(side, meta);
                        ClientHelper.addIcon(icon, names);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return ClientHelper.createLocations(names, cachedBlockIcons, "blocks");
    }

    public static List<ResourceLocation> getAllItemIcons() {
        if (cachedItemIcons != null) {
            return cachedItemIcons;
        }
        cachedItemIcons = Lists.newArrayList();
        ArrayList names = Lists.newArrayList();
        for (Object o : GameData.getItemRegistry().func_148742_b()) {
            Item item = (Item)GameData.getItemRegistry().func_82594_a(o);
            if (item instanceof ItemBlock) continue;
            List<ItemStack> subTypes = ItemStackHelper.getSubTypes(item);
            for (ItemStack stack : subTypes) {
                try {
                    IIcon icon = stack.func_77954_c();
                    ClientHelper.addIcon(icon, names);
                }
                catch (Exception exception) {}
            }
        }
        return ClientHelper.createLocations(names, cachedItemIcons, "items");
    }

    private static List<ResourceLocation> createLocations(List<String> names, List<ResourceLocation> locations, String subFolder) {
        Collections.sort(names);
        for (String name : names) {
            String[] split = name.split(":");
            locations.add(new ResourceLocation(split[0], "textures/" + subFolder + "/" + split[1] + ".png"));
        }
        return locations;
    }

    private static void addIcon(IIcon icon, List<String> names) {
        String iconName = icon.func_94215_i();
        if (iconName.length() == 0) {
            return;
        }
        if (!iconName.contains(":")) {
            iconName = "minecraft:" + iconName;
        }
        if (!names.contains(iconName)) {
            names.add(iconName);
        }
    }

    public static List<ResourceLocation> getPackIcons(BaseContentPack pack, String subFolder) {
        ArrayList icons = Lists.newArrayList();
        List<String> files = ClientHelper.listPathsInPath("assets/" + pack.id.toLowerCase() + "/" + "textures" + "/" + subFolder, pack);
        for (int i = 0; i < files.size(); ++i) {
            files.set(i, pack.id.toLowerCase() + ":" + files.get(i).substring(files.get(i).indexOf(pack.id.toLowerCase()) + pack.id.length() + 1));
        }
        Collections.sort(files);
        for (String file : files) {
            if (!file.endsWith(".png")) continue;
            icons.add(new ResourceLocation(file));
        }
        return icons;
    }

    public static List<String> listPathsInPath(String path, BaseContentPack pack) {
        if (pack.isZipped()) {
            return ClientHelper.listPathsInZip(pack.directory, path);
        }
        return ClientHelper.listPathsInDir(pack.directory, path);
    }

    public static List<String> listPathsInDir(File modDir, String dir) {
        File file = new File(modDir, dir);
        File[] files = file.listFiles();
        ArrayList ret = Lists.newArrayList();
        if (files != null) {
            for (File f : files) {
                ret.add(f.getAbsolutePath().substring(modDir.getAbsolutePath().length() + 1).replace('\\', '/'));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> listPathsInZip(File zipFile, String dir) {
        ArrayList ret = Lists.newArrayList();
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipFile);
            ArrayList<? extends ZipEntry> entries = Collections.list(zip.entries());
            for (ZipEntry zipEntry : entries) {
                File file = new File(zipEntry.getName());
                if ((file.getParent() != null || !dir.equals("")) && (file.getParent() == null || !file.getParent().replace("\\", "/").equals(dir))) continue;
                ret.add(zipEntry.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static String resourceToIconString(ResourceLocation location) {
        String rp = location.func_110623_a();
        return location.func_110624_b() + ":" + rp.substring(rp.lastIndexOf(47) + 1, rp.length() - 4);
    }

    public static void drawResource(Minecraft mc, ResourceLocation location, int x, int y, int width, int height) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)3008);
        mc.field_71446_o.func_110577_a(location);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glScalef((float)(0.00390625f * (float)width), (float)(0.00390625f * (float)height), (float)1.0f);
        GuiBase.INSTANCE.func_73729_b((int)((float)x * 256.0f / (float)width), (int)((float)y * 256.0f / (float)height), 0, 0, 256, 256);
        GL11.glScalef((float)(256 * width), (float)(256 * height), (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glPopMatrix();
    }
}

