/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.util;

import com.google.common.collect.Lists;
import cubex2.cs3.util.GeneralHelper;
import cubex2.cs3.util.StackLabelItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class BlockDrop {
    private List<DropData> drops = Lists.newArrayList();

    public BlockDrop(Block block, int dv) {
        this(Item.func_150898_a((Block)block), dv);
    }

    public BlockDrop(Item item, int dv) {
        DropData data = new DropData();
        data.item = item;
        data.dv = dv;
        data.minCount = 1;
        data.maxCount = 1;
        this.drops.add(data);
    }

    public List<DropData> getDrops() {
        return this.drops;
    }

    public BlockDrop() {
    }

    public ArrayList<ItemStack> getDrops(int fortuneAmount, Random random) {
        ArrayList ret = Lists.newArrayList();
        for (DropData drop : this.drops) {
            int amount = drop.getAmount(random) + fortuneAmount;
            for (int i = 0; i < amount; ++i) {
                ret.add(new ItemStack(drop.getItem(), 1, drop.dv));
            }
        }
        return ret;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.drops.clear();
        NBTTagList list = nbt.func_150295_c("Drops", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound dropNBT = list.func_150305_b(i);
            DropData drop = new DropData();
            drop.itemName = dropNBT.func_74779_i("Item");
            drop.dv = dropNBT.func_74762_e("DV");
            drop.minCount = dropNBT.func_74762_e("Min");
            drop.maxCount = dropNBT.func_74762_e("Max");
            this.drops.add(drop);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (DropData drop : this.drops) {
            NBTTagCompound dropNbt = new NBTTagCompound();
            dropNbt.func_74778_a("Item", GeneralHelper.getItemName(drop.getItem()));
            dropNbt.func_74768_a("DV", drop.dv);
            dropNbt.func_74768_a("Min", drop.minCount);
            dropNbt.func_74768_a("Max", drop.maxCount);
            list.func_74742_a((NBTBase)dropNbt);
        }
        nbt.func_74782_a("Drops", (NBTBase)list);
    }

    public static class DropData
    implements StackLabelItem {
        String itemName;
        Item item;
        int dv;
        int minCount;
        int maxCount;

        public DropData(Item item, int dv, int min, int max) {
            this.item = item;
            this.dv = dv;
            this.minCount = min;
            this.maxCount = max;
        }

        public DropData() {
        }

        public void setAmount(int min, int max) {
            this.minCount = min;
            this.maxCount = max;
        }

        private int getAmount(Random random) {
            if (this.minCount == this.maxCount) {
                return this.minCount;
            }
            return random.nextInt(this.maxCount + 1 - this.minCount) + this.minCount;
        }

        public Item getItem() {
            if (this.item == null) {
                this.item = GeneralHelper.getItem(this.itemName);
            }
            return this.item;
        }

        public ItemStack createStack() {
            return new ItemStack(this.getItem(), 1, this.dv);
        }

        public int getMinCount() {
            return this.minCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        @Override
        public ItemStack getStack() {
            return this.createStack();
        }

        @Override
        public String getLabel() {
            int min = this.getMinCount();
            int max = this.getMaxCount();
            return "Amount: " + min + (min != max ? " - " + max : "");
        }
    }
}

