/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.tileentity;

import com.google.common.collect.Maps;
import cubex2.cs3.common.WrappedTileEntity;
import cubex2.cs3.tileentity.TileEntityCS;
import cubex2.cs3.tileentity.attributes.TileEntityInventoryAttributes;
import cubex2.cs3.tileentity.data.FurnaceModule;
import cubex2.cs3.util.Util;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityInventory
extends TileEntityCS
implements IInventory {
    public ItemStack[] inventoryContents;
    private int slotCount;
    private TileEntityInventoryAttributes invContainer;
    private Map<FurnaceModule, FurnaceData> furnaceData = Maps.newHashMap();

    public TileEntityInventory(WrappedTileEntity wrappedTileEntity) {
        super(wrappedTileEntity);
        this.invContainer = (TileEntityInventoryAttributes)wrappedTileEntity.container;
        this.slotCount = this.invContainer.slotCount;
        this.inventoryContents = new ItemStack[this.slotCount];
    }

    public TileEntityInventory() {
    }

    public FurnaceData getFurnaceData(FurnaceModule module) {
        return this.furnaceData.get(module);
    }

    public int getCookProgressScaled(String name, int width) {
        FurnaceModule module = this.invContainer.furnaceModules.getModule(name);
        if (module == null) {
            return 0;
        }
        return this.furnaceData.get((Object)module).cookTime * width / module.cookTime;
    }

    public int getBurnTimeRemainingScaled(String name, int width) {
        FurnaceModule module = this.invContainer.furnaceModules.getModule(name);
        if (module == null) {
            return 0;
        }
        FurnaceData data = this.getFurnaceData(module);
        if (data.currentBurnTime == 0) {
            data.currentBurnTime = module.cookTime;
        }
        return data.burnTime * width / data.currentBurnTime;
    }

    public TileEntityInventoryAttributes getContainer() {
        return this.invContainer;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        for (FurnaceModule module : this.invContainer.furnaceModules.list) {
            FurnaceData data = this.furnaceData.get(module);
            if (data == null) {
                data = new FurnaceData(0, 0, 0);
                this.furnaceData.put(module, data);
            }
            boolean flag = data.burnTime > 0;
            boolean flag1 = false;
            if (data.burnTime > 0) {
                --data.burnTime;
            }
            if (!this.field_145850_b.field_72995_K) {
                if (data.burnTime != 0 || this.inventoryContents[module.fuelSlot] != null && this.inventoryContents[module.inputSlot] != null) {
                    if (data.burnTime == 0 && this.canSmelt(module)) {
                        data.currentBurnTime = data.burnTime = this.invContainer.getPack().fuelHandler.getItemBurnTime(this.inventoryContents[module.fuelSlot], module.fuelList);
                        if (data.burnTime > 0) {
                            flag1 = true;
                            if (this.inventoryContents[module.fuelSlot] != null) {
                                --this.inventoryContents[module.fuelSlot].field_77994_a;
                                if (this.inventoryContents[module.fuelSlot].field_77994_a == 0) {
                                    this.inventoryContents[module.fuelSlot] = this.inventoryContents[module.fuelSlot].func_77973_b().getContainerItem(this.inventoryContents[module.fuelSlot]);
                                }
                            }
                        }
                    }
                    if (this.isBurning(data) && this.canSmelt(module)) {
                        ++data.cookTime;
                        if (data.cookTime == module.cookTime) {
                            data.cookTime = 0;
                            this.smeltItem(module);
                            flag1 = true;
                        }
                    } else {
                        data.cookTime = 0;
                    }
                }
                if (flag != data.burnTime > 0) {
                    flag1 = true;
                }
            }
            if (!flag1) continue;
            this.func_70296_d();
        }
    }

    public void smeltItem(FurnaceModule module) {
        if (this.canSmelt(module)) {
            ItemStack itemstack = this.invContainer.getPack().smeltingRecipeHandler.getSmeltingResult(this.inventoryContents[module.inputSlot], module.recipeList);
            if (this.inventoryContents[module.outputSlot] == null) {
                this.inventoryContents[module.outputSlot] = itemstack.func_77946_l();
            } else if (this.inventoryContents[module.outputSlot].func_77973_b() == itemstack.func_77973_b()) {
                this.inventoryContents[module.outputSlot].field_77994_a += itemstack.field_77994_a;
            }
            --this.inventoryContents[module.inputSlot].field_77994_a;
            if (this.inventoryContents[module.inputSlot].field_77994_a <= 0) {
                this.inventoryContents[module.inputSlot] = null;
            }
        }
    }

    private boolean isBurning(FurnaceData data) {
        return data.burnTime > 0;
    }

    private boolean canSmelt(FurnaceModule module) {
        if (this.inventoryContents[module.inputSlot] == null) {
            return false;
        }
        ItemStack itemstack = this.invContainer.getPack().smeltingRecipeHandler.getSmeltingResult(this.inventoryContents[module.inputSlot], module.recipeList);
        if (itemstack == null) {
            return false;
        }
        if (this.inventoryContents[module.outputSlot] == null) {
            return true;
        }
        if (!this.inventoryContents[module.outputSlot].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.inventoryContents[module.outputSlot].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.inventoryContents[module.outputSlot].func_77976_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.invContainer = (TileEntityInventoryAttributes)this.container;
        this.slotCount = this.invContainer.slotCount;
        this.inventoryContents = new ItemStack[this.slotCount];
        Util.readStacksFromNBT("CS3_Inv_Items", this.inventoryContents, compound);
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        Util.writeStacksToNBT("CS3_Inv_Items", this.inventoryContents, compound);
    }

    public int func_70302_i_() {
        return this.slotCount;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return p_70301_1_ >= 0 && p_70301_1_ < this.inventoryContents.length ? this.inventoryContents[p_70301_1_] : null;
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        if (this.inventoryContents[p_70298_1_] != null) {
            if (this.inventoryContents[p_70298_1_].field_77994_a <= p_70298_2_) {
                ItemStack itemstack = this.inventoryContents[p_70298_1_];
                this.inventoryContents[p_70298_1_] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.inventoryContents[p_70298_1_].func_77979_a(p_70298_2_);
            if (this.inventoryContents[p_70298_1_].field_77994_a == 0) {
                this.inventoryContents[p_70298_1_] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        if (this.inventoryContents[p_70304_1_] != null) {
            ItemStack itemstack = this.inventoryContents[p_70304_1_];
            this.inventoryContents[p_70304_1_] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.inventoryContents[p_70299_1_] = p_70299_2_;
        if (p_70299_2_ != null && p_70299_2_.field_77994_a > this.func_70297_j_()) {
            p_70299_2_.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "invCS3TileEntity";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public static class FurnaceData {
        public int burnTime;
        public int currentBurnTime;
        public int cookTime;

        public FurnaceData(int burnTime, int currentBurnTime, int cookTime) {
            this.burnTime = burnTime;
            this.currentBurnTime = currentBurnTime;
            this.cookTime = cookTime;
        }
    }
}

