/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.tileentity;

import com.google.common.collect.Maps;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.WrappedTileEntity;
import cubex2.cs3.tileentity.TileEntityCS;
import cubex2.cs3.tileentity.TileEntityInventory;
import cubex2.cs3.tileentity.attributes.TileEntityAttributes;
import cubex2.cs3.tileentity.attributes.TileEntityInventoryAttributes;
import java.lang.reflect.Constructor;
import java.util.Map;

public enum EnumTileEntityType {
    NORMAL("normal", TileEntityCS.class, TileEntityAttributes.class),
    INVENTORY("inventory", TileEntityInventory.class, TileEntityInventoryAttributes.class);

    public final String name;
    public final Class<? extends TileEntityCS> tileEntityClass;
    public final Class<? extends TileEntityAttributes> attributeClass;
    private final Constructor<? extends TileEntityCS> constructor;
    private static final Map<String, EnumTileEntityType> map;

    private EnumTileEntityType(String name, Class<? extends TileEntityCS> tileEntityClass, Class<? extends TileEntityAttributes> attributeClass) {
        this.name = name;
        this.tileEntityClass = tileEntityClass;
        this.attributeClass = attributeClass;
        this.constructor = this.createConstructor();
    }

    private Constructor<? extends TileEntityCS> createConstructor() {
        try {
            return this.tileEntityClass.getConstructor(WrappedTileEntity.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public TileEntityCS createTileEntity(WrappedTileEntity wrappedTileEntity) {
        try {
            TileEntityCS tileEntity = this.constructor.newInstance(wrappedTileEntity);
            return tileEntity;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public TileEntityAttributes createAttributeContainer(WrappedTileEntity wrappedTileEntity) {
        try {
            return this.attributeClass.getConstructor(BaseContentPack.class).newInstance(wrappedTileEntity.getPack());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static EnumTileEntityType get(String name) {
        if (map.isEmpty()) {
            for (EnumTileEntityType e : EnumTileEntityType.values()) {
                map.put(e.name, e);
            }
        }
        return map.get(name);
    }

    static {
        map = Maps.newHashMap();
    }
}

