/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.registry;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.Fuel;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.ingame.gui.WindowFuels;
import cubex2.cs3.registry.ContentRegistry;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.item.ItemStack;

public class FuelRegistry
extends ContentRegistry<Fuel>
implements IFuelHandler {
    public FuelRegistry(BaseContentPack pack) {
        super(pack);
        GameRegistry.registerFuelHandler((IFuelHandler)this);
    }

    @Override
    public Fuel newDataInstance() {
        return new Fuel(this.pack);
    }

    @Override
    public Window createListWindow() {
        return new WindowFuels(this.pack);
    }

    @Override
    public String getNameForEditPack() {
        return "Fuels";
    }

    @Override
    public String getName() {
        return "FuelRegistry";
    }

    public int getBurnTime(ItemStack stack) {
        for (Fuel fuel : this.getContentList()) {
            if (!fuel.isRepresentingStack(stack, "vanilla")) continue;
            return fuel.duration;
        }
        return 0;
    }

    public String[] getFuelLists() {
        HashSet lists = Sets.newHashSet();
        for (Fuel fuel : this.getContentList()) {
            lists.add(fuel.fuelList);
        }
        lists.add("vanilla");
        Object[] ret = lists.toArray(new String[lists.size()]);
        Arrays.sort(ret);
        return ret;
    }
}

