/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.registry;

import com.google.common.collect.Lists;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.Content;
import cubex2.cs3.ingame.gui.Window;
import cubex2.cs3.util.IPurposeStringProvider;
import cubex2.cs3.util.PostponableTask;
import cubex2.cs3.util.StringProviderPurpose;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class ContentRegistry<T extends Content>
implements IPurposeStringProvider,
Comparable<ContentRegistry> {
    protected BaseContentPack pack;
    protected List<T> contentList = Lists.newArrayList();

    public ContentRegistry(BaseContentPack pack) {
        this.pack = pack;
    }

    public List<T> getContentList() {
        return Collections.unmodifiableList(this.contentList);
    }

    public void add(T content) {
        this.contentList.add(content);
    }

    public void remove(T content) {
        this.contentList.remove(content);
    }

    public abstract T newDataInstance();

    public abstract Window createListWindow();

    public abstract String getNameForEditPack();

    public abstract String getName();

    @Override
    public String getStringForPurpose(StringProviderPurpose purpose) {
        if (purpose == StringProviderPurpose.LIST_BOX_ITEM_LABEl) {
            return this.getNameForEditPack();
        }
        return "";
    }

    @Override
    public int compareTo(ContentRegistry o) {
        return this.getNameForEditPack().compareTo(o.getNameForEditPack());
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74778_a("Name", this.getName());
        NBTTagList contentTagList = new NBTTagList();
        for (int i = 0; i < this.contentList.size(); ++i) {
            NBTTagCompound contentCompound = new NBTTagCompound();
            ((Content)this.contentList.get(i)).writeToNBT(contentCompound);
            contentTagList.func_74742_a((NBTBase)contentCompound);
        }
        compound.func_74782_a("ContentList", (NBTBase)contentTagList);
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagList contentTagList = compound.func_150295_c("ContentList", 10);
        for (int i = 0; i < contentTagList.func_74745_c(); ++i) {
            NBTTagCompound contentCompound = contentTagList.func_150305_b(i);
            T data = this.newDataInstance();
            this.pack.postponeHandler.executeTask(new PostponableTask((Content)data, contentCompound){
                final /* synthetic */ Content val$data;
                final /* synthetic */ NBTTagCompound val$contentCompound;
                {
                    this.val$data = content;
                    this.val$contentCompound = nBTTagCompound;
                }

                @Override
                protected boolean doWork() {
                    boolean result = this.val$data.readFromNBT(this.val$contentCompound);
                    if (result) {
                        this.val$data.apply();
                    }
                    return result;
                }
            });
        }
    }
}

