/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cubex2.cs3.common.BaseContentPack;
import cubex2.cs3.common.BaseContentPackLoader;
import cubex2.cs3.common.WrappedGui;
import cubex2.cs3.gui.InventoryItemStack;
import cubex2.cs3.gui.WindowContainerNormal;
import cubex2.cs3.ingame.gui.GuiBase;
import cubex2.cs3.network.PacketOpenCustomGuiClient;
import cubex2.cs3.registry.GuiRegistry;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class PacketOpenUserContainerGuiClient
extends PacketOpenCustomGuiClient {
    private String packName;
    private String guiName;
    private int slotInvType;
    private int slotId;
    private int x;
    private int y;
    private int z;

    public PacketOpenUserContainerGuiClient() {
    }

    public PacketOpenUserContainerGuiClient(WrappedGui gui, int slotId) {
        this.packName = gui.getPack().getName();
        this.guiName = gui.getName();
        this.slotInvType = 0;
        this.slotId = slotId;
    }

    public PacketOpenUserContainerGuiClient(WrappedGui gui, int x, int y, int z) {
        this.packName = gui.getPack().getName();
        this.guiName = gui.getName();
        this.slotInvType = 1;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PacketOpenUserContainerGuiClient(int windowId, WrappedGui gui) {
        super(windowId);
        this.packName = gui.getPack().getName();
        this.guiName = gui.getName();
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.packName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.guiName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.slotInvType = buffer.readByte();
        if (this.slotInvType == 0) {
            this.slotId = buffer.readByte();
        } else if (this.slotInvType == 1) {
            this.x = buffer.readInt();
            this.y = buffer.readInt();
            this.z = buffer.readInt();
        }
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.packName);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.guiName);
        buffer.writeByte(this.slotInvType);
        if (this.slotInvType == 0) {
            buffer.writeByte(this.slotId);
        } else if (this.slotInvType == 1) {
            buffer.writeInt(this.x);
            buffer.writeInt(this.y);
            buffer.writeInt(this.z);
        }
    }

    public static class Handler
    extends PacketOpenCustomGuiClient.Handler<PacketOpenUserContainerGuiClient> {
        @Override
        @SideOnly(value=Side.CLIENT)
        protected Object getClientGuiElement(PacketOpenUserContainerGuiClient message, EntityPlayer player) {
            BaseContentPack pack = BaseContentPackLoader.instance().getContentPack(message.packName);
            WrappedGui gui = ((GuiRegistry)pack.getContentRegistry(WrappedGui.class)).getGui(message.guiName);
            InventoryItemStack slotInv = message.slotInvType == 0 ? new InventoryItemStack(gui, player, message.slotId) : (IInventory)player.field_70170_p.func_147438_o(message.x, message.y, message.z);
            return GuiBase.createContainerGui(new WindowContainerNormal(gui, slotInv));
        }
    }
}

