/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.lib;

import com.google.common.collect.Maps;
import cubex2.cs3.api.scripting.TriggerType;
import cubex2.cs3.lib.ScriptInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Scripts {
    public static final Map<TriggerType, Map<String, ScriptInfo>> infos = Maps.newHashMap();
    public static final ScriptInfo BLOCK_ON_ADDED = Scripts.addBlock("onAdded", "world", "position");
    public static final ScriptInfo BLOCK_ON_ACTIVATED = Scripts.addBlock("onActivated", "world", "position", "player", "hitX", "hitY", "side");
    public static final ScriptInfo BLOCK_ON_BONEMEAL = Scripts.addBlock("onBonemeal", "world", "position", "player");
    public static final ScriptInfo BLOCK_ON_UPDATE = Scripts.addBlock("onUpdate", "world", "position");
    public static final ScriptInfo BLOCK_ON_DESTROYED_BY_PLAYER = Scripts.addBlock("onDestroyedByPlayer", "world", "position", "player");
    public static final ScriptInfo BLOCK_ON_NEIGHBOR_CHANGE = Scripts.addBlock("onNeighborChange", "world", "position");
    public static final ScriptInfo BLOCK_ON_REDSTONE_SIGNAL = Scripts.addBlock("onRedstoneSignal", "world", "position");
    public static final ScriptInfo BLOCK_ON_BREAK = Scripts.addBlock("onBreak", "world", "position");
    public static final ScriptInfo BLOCK_ON_WALKING = Scripts.addBlock("onWalking", "world", "position", "entity");
    public static final ScriptInfo BLOCK_ON_PLACED = Scripts.addBlock("onPlaced", "world", "position");
    public static final ScriptInfo BLOCK_ON_CLICKED = Scripts.addBlock("onClicked", "world", "position", "player");
    public static final ScriptInfo BLOCK_ON_COLLIDED = Scripts.addBlock("onCollided", "world", "position", "entity");
    public static final ScriptInfo BLOCK_ON_PLACED_BY_PLAYER = Scripts.addBlock("onPlacedByPlayer", "world", "position", "player");
    public static final ScriptInfo BLOCK_ON_PLACED_BY = Scripts.addBlock("onPlacedBy", "world", "position", "living");
    public static final ScriptInfo BLOCK_ON_FALLEN_UPON = Scripts.addBlock("onFallenUpon", "world", "position", "entity");
    public static final ScriptInfo BLOCK_ON_RANDOM_DISPLAY_TICK = Scripts.addBlock("onRandomDisplayTick", "world", "position");
    public static final ScriptInfo ITEM_ON_USE = Scripts.addItem("onUse", "world", "player", "itemstack", "position", "hitX", "hitY", "side");
    public static final ScriptInfo ITEM_ON_EATEN = Scripts.addItem("onEaten", "world", "player", "itemstack");
    public static final ScriptInfo ITEM_ON_RIGHT_CLICK = Scripts.addItem("onRightClick", "world", "player", "itemstack");
    public static final ScriptInfo ITEM_ON_USE_FIRST = Scripts.addItem("onUseFirst", "world", "player", "itemstack", "position", "hitX", "hitY", "side");
    public static final ScriptInfo ITEM_ON_USE_ON_PLAYER = Scripts.addItem("onUseOnPlayer", "world", "player", "itemstack", "interactPlayer");
    public static final ScriptInfo ITEM_ON_USE_ON_ENTITY = Scripts.addItem("onUseOnEntity", "world", "player", "itemstack", "living");
    public static final ScriptInfo ITEM_ON_BLOCK_DESTROYED = Scripts.addItem("onBlockDestroyed", "world", "player", "itemstack", "position", "blockName");
    public static final ScriptInfo ITEM_ON_HIT_ENTITY = Scripts.addItem("onHitEntity", "world", "player", "itemstack", "living");
    public static final ScriptInfo ITEM_ON_LEFT_CLICK_LIVING = Scripts.addItem("onLeftClickLiving", "world", "player", "itemstack", "living");
    public static final ScriptInfo ITEM_ON_LEFT_CLICK_PLAYER = Scripts.addItem("onLeftClickPlayer", "world", "player", "itemstack", "interactPlayer");
    public static final ScriptInfo ITEM_ON_UPDATE = Scripts.addItem("onUpdate", "world", "player", "itemstack", "slotId", "isCurrentItem");
    public static final ScriptInfo ITEM_ON_CREATED = Scripts.addItem("onCreated", "world", "player", "itemstack");
    public static final ScriptInfo ITEM_ON_USING = Scripts.addItem("onUsing", "world", "player", "itemstack", "tickCount");
    public static final ScriptInfo ITEM_ON_STOPPED_USING = Scripts.addItem("onStoppedUsing", "world", "player", "itemstack", "tickCount");
    public static final ScriptInfo ITEM_ON_DROPPED_BY_PLAYER = Scripts.addItem("onDroppedByPlayer", "world", "player", "itemstack");
    public static final ScriptInfo ITEM_ON_BLOCK_START_BREAK = Scripts.addItem("onBlockStartBreak", "world", "player", "itemstack", "position");
    public static final ScriptInfo ITEM_ON_ARMOR_UPDATE = Scripts.addItem("onArmorUpdate", "world", "player", "itemstack");
    public static final ScriptInfo GUI_BUTTON_ON_CLICKED = Scripts.addGui("button/onClicked", "player");

    public static ScriptInfo getInfo(String scriptName, TriggerType type) {
        return infos.get((Object)type).get(scriptName);
    }

    private static ScriptInfo addBlock(String name, String ... objects) {
        return Scripts.add(TriggerType.BLOCK, name, objects);
    }

    private static ScriptInfo addItem(String name, String ... objects) {
        return Scripts.add(TriggerType.ITEM, name, objects);
    }

    private static ScriptInfo addGui(String name, String ... objects) {
        return Scripts.add(TriggerType.GUI, name, objects);
    }

    private static ScriptInfo addEvent(String name, String ... objects) {
        return Scripts.add(TriggerType.EVENT, name, objects);
    }

    private static ScriptInfo add(TriggerType type, String name, String[] objects) {
        if (!infos.containsKey((Object)type)) {
            infos.put(type, new HashMap());
        }
        Arrays.sort(objects);
        ScriptInfo info = new ScriptInfo(objects);
        infos.get((Object)type).put(name, info);
        return info;
    }
}

