/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.lib;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.potion.Potion;

public class Potions {
    private static Map<String, Potion> potionMap = Maps.newHashMap();
    private static final Comparator<Potion> COMPARATOR = new Comparator<Potion>(){

        @Override
        public int compare(Potion o1, Potion o2) {
            return Potions.getPotionName(o1).compareTo(Potions.getPotionName(o2));
        }
    };

    public static Potion getPotion(String name) {
        if (name == null) {
            return null;
        }
        Potion potion = null;
        if (!name.startsWith("potion.")) {
            name = "potion.".concat(name);
        }
        if (potionMap.containsKey(name)) {
            potion = potionMap.get(name);
        } else {
            for (Potion p : Potion.field_76425_a) {
                if (p == null || !p.func_76393_a().equals(name)) continue;
                potionMap.put(p.func_76393_a(), p);
                potion = p;
                break;
            }
        }
        return potion;
    }

    public static String getPotionName(Potion potion) {
        return potion == null ? null : potion.func_76393_a().replaceFirst("potion\\.", "");
    }

    public static Potion[] getPotions(boolean addNull) {
        ArrayList res = Lists.newArrayList();
        for (Potion p : Potion.field_76425_a) {
            if (p == null) continue;
            res.add(p);
        }
        Collections.sort(res, COMPARATOR);
        if (addNull) {
            res.add(0, null);
        }
        return res.toArray(new Potion[res.size()]);
    }
}

