/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.lib;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.block.material.Material;

public class Materials {
    private static BiMap<String, Material> materialMap = HashBiMap.create();

    public static Material getMaterial(String name) {
        if (name == null) {
            return null;
        }
        Material material = null;
        if (materialMap.containsKey((Object)name)) {
            material = (Material)materialMap.get((Object)name);
        }
        return material;
    }

    public static String getMaterialName(Material material) {
        if (material == null) {
            return null;
        }
        String name = null;
        if (materialMap.inverse().containsKey((Object)material)) {
            name = (String)materialMap.inverse().get((Object)material);
        }
        return name;
    }

    public static Material[] getAllMaterials() {
        return materialMap.values().toArray(new Material[materialMap.values().size()]);
    }

    static {
        materialMap.put((Object)"cactus", (Object)Material.field_151570_A);
        materialMap.put((Object)"circuits", (Object)Material.field_151594_q);
        materialMap.put((Object)"clay", (Object)Material.field_151571_B);
        materialMap.put((Object)"cloth", (Object)Material.field_151580_n);
        materialMap.put((Object)"craftedSnow", (Object)Material.field_151596_z);
        materialMap.put((Object)"fire", (Object)Material.field_151581_o);
        materialMap.put((Object)"glass", (Object)Material.field_151592_s);
        materialMap.put((Object)"grass", (Object)Material.field_151577_b);
        materialMap.put((Object)"ground", (Object)Material.field_151578_c);
        materialMap.put((Object)"ice", (Object)Material.field_151588_w);
        materialMap.put((Object)"iron", (Object)Material.field_151573_f);
        materialMap.put((Object)"lava", (Object)Material.field_151587_i);
        materialMap.put((Object)"leaves", (Object)Material.field_151584_j);
        materialMap.put((Object)"plants", (Object)Material.field_151585_k);
        materialMap.put((Object)"pumpkin", (Object)Material.field_151572_C);
        materialMap.put((Object)"redstoneLight", (Object)Material.field_151591_t);
        materialMap.put((Object)"rock", (Object)Material.field_151576_e);
        materialMap.put((Object)"sand", (Object)Material.field_151595_p);
        materialMap.put((Object)"snow", (Object)Material.field_151597_y);
        materialMap.put((Object)"sponge", (Object)Material.field_151583_m);
        materialMap.put((Object)"tnt", (Object)Material.field_151590_u);
        materialMap.put((Object)"vine", (Object)Material.field_151582_l);
        materialMap.put((Object)"water", (Object)Material.field_151586_h);
        materialMap.put((Object)"wood", (Object)Material.field_151575_d);
    }
}

