/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs3.lib;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.biome.BiomeGenBase;

public class Biomes {
    private static Map<String, BiomeGenBase> biomeMap = Maps.newHashMap();
    public static final Comparator<BiomeGenBase> COMPARATOR = new Comparator<BiomeGenBase>(){

        @Override
        public int compare(BiomeGenBase o1, BiomeGenBase o2) {
            return o1.field_76791_y.compareTo(o2.field_76791_y);
        }
    };

    public static BiomeGenBase getBiome(String name) {
        if (name == null) {
            return null;
        }
        BiomeGenBase biome = null;
        if (biomeMap.containsKey(name)) {
            biome = biomeMap.get(name);
        } else {
            for (BiomeGenBase b : BiomeGenBase.func_150565_n()) {
                if (b == null || !b.field_76791_y.equals(name)) continue;
                biomeMap.put(b.field_76791_y, b);
                biome = b;
                break;
            }
        }
        return biome;
    }

    public static Set<String> getBiomeNames() {
        HashSet res = Sets.newHashSet();
        for (BiomeGenBase b : BiomeGenBase.func_150565_n()) {
            if (b == null) continue;
            res.add(b.field_76791_y);
        }
        return res;
    }

    public static List<BiomeGenBase> getBiomes() {
        ArrayList res = Lists.newArrayList();
        for (BiomeGenBase b : BiomeGenBase.func_150565_n()) {
            if (b == null) continue;
            res.add(b);
        }
        return res;
    }
}

